/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swing.data;

import java.net.URL;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.jdesktop.swing.data.ConversionException;
import org.jdesktop.swing.data.Converter;
import org.jdesktop.swing.data.Link;

public class Converters {
    private static Map map = new HashMap();
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;
    static /* synthetic */ Class class$4;
    static /* synthetic */ Class class$5;
    static /* synthetic */ Class class$6;
    static /* synthetic */ Class class$7;
    static /* synthetic */ Class class$8;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("java.lang.Boolean");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        map.put(clazz, "org.jdesktop.swing.data.Converters$BooleanConverter");
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("java.util.Date");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        map.put(clazz2, "org.jdesktop.swing.data.Converters$DateConverter");
        Class<?> clazz3 = class$2;
        if (clazz3 == null) {
            try {
                clazz3 = class$2 = Class.forName("java.lang.Double");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        map.put(clazz3, "org.jdesktop.swing.data.Converters$DoubleConverter");
        Class<?> clazz4 = class$3;
        if (clazz4 == null) {
            try {
                clazz4 = class$3 = Class.forName("java.lang.Float");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        map.put(clazz4, "org.jdesktop.swing.data.Converters$FloatConverter");
        Class<?> clazz5 = class$4;
        if (clazz5 == null) {
            try {
                clazz5 = class$4 = Class.forName("java.lang.Integer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        map.put(clazz5, "org.jdesktop.swing.data.Converters$IntegerConverter");
        Class<?> clazz6 = class$5;
        if (clazz6 == null) {
            try {
                clazz6 = class$5 = Class.forName("org.jdesktop.swing.data.Link");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        map.put(clazz6, "org.jdesktop.swing.data.Converters$LinkConverter");
        Class<?> clazz7 = class$6;
        if (clazz7 == null) {
            try {
                clazz7 = class$6 = Class.forName("java.lang.Long");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        map.put(clazz7, "org.jdesktop.swing.data.Converters$LongConverter");
        Class<?> clazz8 = class$7;
        if (clazz8 == null) {
            try {
                clazz8 = class$7 = Class.forName("java.lang.Short");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        map.put(clazz8, "org.jdesktop.swing.data.Converters$ShortConverter");
        Class<?> clazz9 = class$8;
        if (clazz9 == null) {
            try {
                clazz9 = class$8 = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        map.put(clazz9, "org.jdesktop.swing.data.Converters$StringConverter");
    }

    public static Converter get(Class klass) {
        Object obj = map.get(klass);
        Converter converter = null;
        if (obj != null) {
            if (obj instanceof String) {
                try {
                    Class<?> cls = Class.forName((String)obj);
                    converter = (Converter)cls.newInstance();
                    map.put(klass, converter);
                }
                catch (Exception ex) {
                    converter = null;
                }
            } else {
                converter = (Converter)obj;
            }
        }
        return converter;
    }

    public static void put(Class klass, Converter converter) {
        map.put(klass, converter);
    }

    public static Class[] getTypes() {
        Set keys = map.keySet();
        return keys.toArray(new Class[0]);
    }

    protected Converters() {
    }

    static class StringConverter
    implements Converter {
        static /* synthetic */ Class class$0;

        StringConverter() {
        }

        public String encode(Object value, Object format) throws ConversionException {
            if (value != null && value instanceof String) {
                return (String)value;
            }
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("java.lang.String");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            throw new ConversionException(value, (Class)clazz);
        }

        public Object decode(String value, Object format) throws ConversionException {
            try {
                return value.toString();
            }
            catch (Exception e) {
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("java.lang.String");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                throw new ConversionException(value, (Class)clazz, (Throwable)e);
            }
        }
    }

    static class BooleanConverter
    implements Converter {
        static /* synthetic */ Class class$0;

        BooleanConverter() {
        }

        public String encode(Object value, Object format) throws ConversionException {
            try {
                Boolean boolValue = (Boolean)value;
                return boolValue.toString();
            }
            catch (Exception e) {
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("java.lang.Boolean");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                throw new ConversionException(value, (Class)clazz, (Throwable)e);
            }
        }

        public Object decode(String value, Object format) throws ConversionException {
            try {
                return Boolean.valueOf(value);
            }
            catch (Exception e) {
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("java.lang.Boolean");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                throw new ConversionException(value, (Class)clazz, (Throwable)e);
            }
        }
    }

    static class IntegerConverter
    implements Converter {
        static /* synthetic */ Class class$0;

        IntegerConverter() {
        }

        public String encode(Object value, Object format) throws ConversionException {
            try {
                int intValue = (Integer)value;
                int radix = format == null ? 10 : (Integer)format;
                return Integer.toString(intValue, radix);
            }
            catch (Exception e) {
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("java.lang.Integer");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                throw new ConversionException(value, (Class)clazz, (Throwable)e);
            }
        }

        public Object decode(String value, Object format) throws ConversionException {
            try {
                int radix = format == null ? 10 : (Integer)format;
                return Integer.valueOf(value, radix);
            }
            catch (Exception e) {
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("java.lang.Integer");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                throw new ConversionException(value, (Class)clazz, (Throwable)e);
            }
        }
    }

    static class LongConverter
    implements Converter {
        static /* synthetic */ Class class$0;

        LongConverter() {
        }

        public String encode(Object value, Object format) throws ConversionException {
            try {
                long longValue = (Long)value;
                int radix = format == null ? 10 : (Integer)format;
                return Long.toString(longValue, radix);
            }
            catch (Exception e) {
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("java.lang.Long");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                throw new ConversionException(value, (Class)clazz, (Throwable)e);
            }
        }

        public Object decode(String value, Object format) throws ConversionException {
            try {
                int radix = format == null ? 10 : (Integer)format;
                return Long.valueOf(value, radix);
            }
            catch (Exception e) {
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("java.lang.Long");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                throw new ConversionException(value, (Class)clazz, (Throwable)e);
            }
        }
    }

    static class ShortConverter
    implements Converter {
        static /* synthetic */ Class class$0;

        ShortConverter() {
        }

        public String encode(Object value, Object format) throws ConversionException {
            try {
                int shortValue = ((Short)value).intValue();
                int radix = format == null ? 10 : (Integer)format;
                return Integer.toString(shortValue, radix);
            }
            catch (Exception e) {
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("java.lang.Short");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                throw new ConversionException(value, (Class)clazz, (Throwable)e);
            }
        }

        public Object decode(String value, Object format) throws ConversionException {
            try {
                int radix = format == null ? 10 : (Integer)format;
                return Short.valueOf(value, radix);
            }
            catch (Exception e) {
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("java.lang.Short");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                throw new ConversionException(value, (Class)clazz, (Throwable)e);
            }
        }
    }

    static class FloatConverter
    implements Converter {
        static /* synthetic */ Class class$0;

        FloatConverter() {
        }

        public String encode(Object value, Object format) throws ConversionException {
            try {
                Float floatValue = (Float)value;
                return floatValue.toString();
            }
            catch (Exception e) {
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("java.lang.Float");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                throw new ConversionException(value, (Class)clazz, (Throwable)e);
            }
        }

        public Object decode(String value, Object format) throws ConversionException {
            try {
                return Float.valueOf(value);
            }
            catch (Exception e) {
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("java.lang.Float");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                throw new ConversionException(value, (Class)clazz, (Throwable)e);
            }
        }
    }

    static class DoubleConverter
    implements Converter {
        static /* synthetic */ Class class$0;

        DoubleConverter() {
        }

        public String encode(Object value, Object format) throws ConversionException {
            try {
                Double doubleValue = (Double)value;
                return doubleValue.toString();
            }
            catch (Exception e) {
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("java.lang.Double");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                throw new ConversionException(value, (Class)clazz, (Throwable)e);
            }
        }

        public Object decode(String value, Object format) throws ConversionException {
            try {
                return Double.valueOf(value);
            }
            catch (Exception e) {
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("java.lang.Double");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                throw new ConversionException(value, (Class)clazz, (Throwable)e);
            }
        }
    }

    public static class DateConverter
    implements Converter {
        private DateFormat defaultInputFormat;
        private DateFormat defaultOutputFormat;
        static /* synthetic */ Class class$0;

        public DateConverter() {
            this.defaultInputFormat = this.defaultOutputFormat = new SimpleDateFormat("EEE MMM dd HH:mm:ss z yyyy");
        }

        public DateConverter(DateFormat defaultInputFormat, DateFormat defaultOutputFormat) {
            this.defaultInputFormat = defaultInputFormat;
            this.defaultOutputFormat = defaultOutputFormat;
        }

        public String encode(Object value, Object format) throws ConversionException {
            try {
                DateFormat dateFormat = format == null ? this.defaultOutputFormat : (DateFormat)format;
                return dateFormat.format((Date)value);
            }
            catch (Exception e) {
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("java.util.Date");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                throw new ConversionException(value, (Class)clazz, (Throwable)e);
            }
        }

        public Object decode(String value, Object format) throws ConversionException {
            try {
                DateFormat dateFormat = format == null ? this.defaultInputFormat : (DateFormat)format;
                return dateFormat.parse(value);
            }
            catch (Exception e) {
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("java.util.Date");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                throw new ConversionException(value, (Class)clazz, (Throwable)e);
            }
        }
    }

    static class LinkConverter
    implements Converter {
        private static final String URL_BEGIN = "<a href=\"";
        private static final String URL_MARKER = "%u";
        private static final String URL_END = "\"";
        private static final String TARGET_BEGIN = " target=\"";
        private static final String TARGET_MARKER = "%t";
        private static final String TARGET_END = "\"";
        private static final String DISPLAY_BEGIN = ">";
        private static final String DISPLAY_MARKER = "%d";
        private static final String DISPLAY_END = "</a>";
        private static final String TEMPLATE = "<a href=\"%u\" target=\"%t\">%d</a>";
        private static final String TEMPLATE2 = "<a href=\"%u\">%d</a>";
        static /* synthetic */ Class class$0;

        LinkConverter() {
        }

        public String encode(Object value, Object format) throws ConversionException {
            try {
                String linkString;
                Link link = (Link)value;
                String target = link.getTarget();
                if (target != null) {
                    linkString = TEMPLATE.replaceFirst(URL_MARKER, link.getURL().toExternalForm());
                    linkString = linkString.replaceFirst(TARGET_MARKER, target);
                } else {
                    linkString = TEMPLATE2.replaceFirst(URL_MARKER, link.getURL().toExternalForm());
                }
                linkString = linkString.replaceFirst(DISPLAY_MARKER, link.getText());
                return linkString;
            }
            catch (Exception e) {
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("org.jdesktop.swing.data.Link");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                throw new ConversionException(value, (Class)clazz, (Throwable)e);
            }
        }

        public Object decode(String value, Object format) throws ConversionException {
            try {
                String url = value.substring(URL_BEGIN.length(), value.indexOf("\"", URL_BEGIN.length() + 1));
                String target = null;
                int targetIndex = value.indexOf(TARGET_BEGIN);
                if (targetIndex != -1) {
                    target = value.substring(targetIndex + TARGET_BEGIN.length(), value.indexOf("\"", targetIndex + TARGET_BEGIN.length() + 1));
                }
                String display = value.substring(value.indexOf(DISPLAY_BEGIN) + DISPLAY_BEGIN.length(), value.indexOf(DISPLAY_END));
                return new Link(display, target, new URL(url));
            }
            catch (Exception e) {
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("org.jdesktop.swing.data.Link");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                throw new ConversionException(value, (Class)clazz, (Throwable)e);
            }
        }
    }
}

