/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swing.data;

import java.io.IOException;
import java.io.InputStream;
import javax.swing.SwingUtilities;
import org.jdesktop.swing.data.ConversionException;
import org.jdesktop.swing.event.MessageListener;
import org.jdesktop.swing.event.MessageSource;
import org.jdesktop.swing.event.MessageSourceSupport;
import org.jdesktop.swing.event.ProgressListener;
import org.jdesktop.swing.event.ProgressSource;

public abstract class DataLoader
implements ProgressSource,
MessageSource {
    public static final String READER_PRIORITY_KEY = "swingx.readpriority";
    private LoadNotifier loadNotifier;
    private MessageSourceSupport mss = new MessageSourceSupport(this);

    protected DataLoader() {
    }

    public void addProgressListener(ProgressListener l) {
        this.mss.addProgressListener(l);
    }

    public void removeProgressListener(ProgressListener l) {
        this.mss.removeProgressListener(l);
    }

    public ProgressListener[] getProgressListeners() {
        return this.mss.getProgressListeners();
    }

    public void addMessageListener(MessageListener l) {
        this.mss.addMessageListener(l);
    }

    public void removeMessageListener(MessageListener l) {
        this.mss.removeMessageListener(l);
    }

    public MessageListener[] getMessageListeners() {
        return this.mss.getMessageListeners();
    }

    public abstract void loadMetaData(Object var1, InputStream var2) throws IOException;

    public void startLoading(Object model, final InputStream is) {
        this.loadNotifier = new LoadNotifier(this, model);
        Runnable task = new Runnable(){

            public void run() {
                try {
                    DataLoader.this.readData(is);
                }
                catch (Exception e) {
                    final Exception error = e;
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            DataLoader.this.fireException(error);
                        }
                    });
                }
            }
        };
        Thread readerThread = new Thread(task);
        readerThread.setPriority(this.getReaderThreadPriority());
        this.fireProgressStarted(1, 1);
        readerThread.start();
    }

    protected int getReaderThreadPriority() {
        String priority = System.getProperty(READER_PRIORITY_KEY);
        if (priority != null) {
            try {
                int prio = Integer.parseInt(priority);
                return Math.max(1, prio);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return 1;
    }

    protected abstract void readData(InputStream var1) throws IOException, ConversionException;

    protected abstract void loadData(Object var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void scheduleLoad() {
        LoadNotifier loadNotifier = this.loadNotifier;
        synchronized (loadNotifier) {
            if (!this.loadNotifier.isPending()) {
                this.loadNotifier.setPending(true);
                SwingUtilities.invokeLater(this.loadNotifier);
            }
        }
    }

    protected void fireProgressStarted(int minimum, int maximum) {
        this.mss.fireProgressStarted(minimum, maximum);
    }

    protected void fireProgressIncremented(int progress) {
        this.mss.fireProgressIncremented(progress);
    }

    protected void fireProgressEnded() {
        this.mss.fireProgressEnded();
    }

    protected void fireException(Throwable t) {
        this.mss.fireException(t);
    }

    protected void fireMessage(String message) {
        this.mss.fireMessage(message);
    }

    private class LoadNotifier
    implements Runnable {
        private DataLoader loader;
        private Object model;
        private boolean pending = false;

        LoadNotifier(DataLoader loader, Object model) {
            this.loader = loader;
            this.model = model;
        }

        public synchronized void setPending(boolean pending) {
            this.pending = pending;
        }

        public synchronized boolean isPending() {
            return this.pending;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            LoadNotifier loadNotifier = this;
            synchronized (loadNotifier) {
                this.loader.loadData(this.model);
                this.setPending(false);
            }
        }
    }
}

