/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swing.data;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jdesktop.swing.data.ConversionException;
import org.jdesktop.swing.data.Converter;
import org.jdesktop.swing.data.DataLoader;
import org.jdesktop.swing.data.MetaData;
import org.jdesktop.swing.data.TabularDataModel;

public class TabularDataTextLoader
extends DataLoader {
    private String columnDelimiter;
    private boolean firstRowHeader;
    private int blockSize;
    private int columnCount = 0;
    private MetaData[] columnMetaData;
    private List rows;
    private boolean complete = false;

    public TabularDataTextLoader() {
        this("\t", false, 50);
    }

    public TabularDataTextLoader(String columnDelimiter, boolean isFirstRowHeader, int blockIncrementSize) {
        this.columnDelimiter = columnDelimiter;
        this.firstRowHeader = isFirstRowHeader;
        this.blockSize = blockIncrementSize;
    }

    public String getColumnDelimiter() {
        return this.columnDelimiter;
    }

    public void setColumnDelimiter(String regex) {
        this.columnDelimiter = regex;
    }

    public boolean isFirstRowHeader() {
        return this.firstRowHeader;
    }

    public void setFirstRowHeader(boolean isFirstRowHeader) {
        this.firstRowHeader = isFirstRowHeader;
    }

    public int getBlockIncrementSize() {
        return this.blockSize;
    }

    public void setBlockIncrementSize(int blockIncrementSize) {
        this.blockSize = blockIncrementSize;
    }

    public void loadMetaData(Object model, InputStream is) throws IOException {
        TabularDataModel dataModel = (TabularDataModel)model;
        BufferedReader reader = new BufferedReader(new InputStreamReader(is));
        String firstLine = reader.readLine();
        String[] columns = firstLine.split(this.columnDelimiter);
        dataModel.setColumnCount(columns.length);
        if (this.firstRowHeader) {
            int i = 0;
            while (i < columns.length) {
                MetaData metaData = dataModel.getColumnMetaData(i);
                metaData.setName(columns[i]);
                ++i;
            }
        }
        reader.close();
    }

    public void startLoading(Object model, InputStream is) {
        TabularDataModel dataModel = (TabularDataModel)model;
        this.columnCount = dataModel.getColumnCount();
        this.columnMetaData = dataModel.getMetaData();
        super.startLoading(model, is);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void readData(InputStream is) throws IOException, ConversionException {
        BufferedReader reader = new BufferedReader(new InputStreamReader(is));
        StringBuffer strbuf = new StringBuffer();
        if (this.columnCount == 0) {
            throw new IOException("cannot read data when column count is 0");
        }
        boolean colIndex = false;
        int rowCount = 0;
        Object[] row = null;
        this.rows = Collections.synchronizedList(new ArrayList());
        String line = reader.readLine();
        if (this.firstRowHeader) {
            line = reader.readLine();
        }
        while (line != null) {
            String[] columns = line.split(this.columnDelimiter);
            row = new Object[this.columnCount];
            int i = 0;
            while (i < this.columnCount) {
                if (i < columns.length) {
                    row[i] = this.convertToValue(i, columns[i]);
                }
                ++i;
            }
            List list = this.rows;
            synchronized (list) {
                this.rows.add(row);
                if (++rowCount % this.blockSize == 0) {
                    this.scheduleLoad();
                }
            }
            line = reader.readLine();
        }
        this.complete = true;
        this.scheduleLoad();
        reader.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void loadData(Object model) {
        TabularDataModel dataModel = (TabularDataModel)model;
        boolean done = false;
        List list = this.rows;
        synchronized (list) {
            dataModel.loadRows(this.rows);
            this.rows.clear();
            done = this.complete;
        }
        if (done) {
            this.fireProgressEnded();
        }
    }

    private Object convertToValue(int colIndex, String stringValue) throws ConversionException {
        Object value = null;
        if (stringValue.length() == 0) {
            return null;
        }
        Converter converter = this.columnMetaData[colIndex].getConverter();
        value = converter == null ? stringValue : converter.decode(stringValue, this.columnMetaData[colIndex].getDecodeFormat());
        return value;
    }
}

