/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swing.decorator;

import java.awt.Color;
import java.awt.Component;
import org.jdesktop.swing.decorator.ComponentAdapter;
import org.jdesktop.swing.decorator.Highlighter;

public abstract class ConditionalHighlighter
extends Highlighter {
    protected int testColumn = 0;
    protected int highlightColumn = -1;
    protected int mask = 255;

    public ConditionalHighlighter() {
    }

    public ConditionalHighlighter(Color cellBackground, Color cellForeground, int testColumn, int highlightColumn) {
        super(cellBackground, cellForeground);
        this.testColumn = testColumn;
        this.highlightColumn = highlightColumn;
    }

    public void setMask(int alpha) {
        this.mask = alpha;
    }

    public int getMask() {
        return this.mask;
    }

    public Component highlight(Component renderer, ComponentAdapter adapter) {
        if (this.needsHighlight(adapter)) {
            return this.doHighlight(renderer, adapter);
        }
        if (this.getMask() < 256) {
            return this.doMask(renderer, adapter);
        }
        return renderer;
    }

    protected Component doMask(Component renderer, ComponentAdapter adapter) {
        this.maskBackground(renderer, adapter);
        this.maskForeground(renderer, adapter);
        return renderer;
    }

    protected void maskBackground(Component renderer, ComponentAdapter adapter) {
        Color seed = renderer.getBackground();
        Color color = adapter.isSelected() ? this.computeSelectedBackground(seed) : seed;
        renderer.setBackground(new Color(this.getMask() << 24 | color.getRGB() & 0xFFFFFF, true));
    }

    protected void maskForeground(Component renderer, ComponentAdapter adapter) {
        Color seed = renderer.getForeground();
        Color color = adapter.isSelected() ? this.computeSelectedForeground(seed) : seed;
        renderer.setForeground(new Color(this.getMask() << 24 | color.getRGB() & 0xFFFFFF, true));
    }

    protected Color computeBackground(Component renderer, ComponentAdapter adapter) {
        return this.getBackground() == null ? null : super.computeBackground(renderer, adapter);
    }

    protected Color computeForeground(Component renderer, ComponentAdapter adapter) {
        return this.getForeground() == null ? null : super.computeForeground(renderer, adapter);
    }

    protected Color computeSelectedForeground(Color seed) {
        return this.getSelectedForeground() == null ? seed.brighter() : this.getSelectedForeground();
    }

    public int getTestColumnIndex() {
        return this.testColumn;
    }

    public void setTestColumnIndex(int columnIndex) {
        this.testColumn = columnIndex;
    }

    public int getHighlightColumnIndex() {
        return this.highlightColumn;
    }

    public void setHighlightColumnIndex(int columnIndex) {
        this.highlightColumn = columnIndex;
    }

    protected boolean needsHighlight(ComponentAdapter adapter) {
        if (this.highlightColumn < 0 || adapter.modelToView(this.highlightColumn) == adapter.column) {
            return this.test(adapter);
        }
        return false;
    }

    protected abstract boolean test(ComponentAdapter var1);
}

