/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swing.decorator;

import org.jdesktop.swing.decorator.ComponentAdapter;
import org.jdesktop.swing.decorator.FilterPipeline;

public abstract class Filter {
    private final int column;
    private FilterPipeline pipeline = null;
    protected ComponentAdapter adapter = null;
    int order = -1;

    public Filter() {
        this(0);
    }

    public Filter(int col) {
        this.column = col;
        this.init();
    }

    protected abstract void init();

    protected abstract void reset();

    protected abstract void generateMappingFromPrevious();

    protected abstract void filter();

    public void refresh() {
        this.refresh(true);
    }

    protected void refresh(boolean reset) {
        if (reset) {
            this.reset();
        }
        this.filter();
        this.generateMappingFromPrevious();
        if (this.pipeline != null && this.pipeline.contains(this)) {
            this.pipeline.filterChanged(this);
            return;
        }
        if (this.adapter != null) {
            this.adapter.refresh();
        }
    }

    final void assign(ComponentAdapter adapter) {
        if (adapter == null) {
            throw new IllegalArgumentException("null adapter");
        }
        if (this.adapter == null) {
            this.adapter = adapter;
        } else if (this.adapter != adapter) {
            throw new IllegalStateException("Already bound to another adapter");
        }
    }

    final void assign(FilterPipeline pipeline) {
        if (this.pipeline == null || pipeline == null) {
            this.pipeline = pipeline;
        } else if (this.pipeline != pipeline) {
            throw new IllegalStateException("Already bound to another pipeline");
        }
    }

    protected FilterPipeline getPipeline() {
        return this.pipeline;
    }

    public int getColumnIndex() {
        return this.column;
    }

    public String getColumnName() {
        if (this.adapter == null) {
            return "Column " + this.column;
        }
        int viewColumnIndex = this.adapter.modelToView(this.getColumnIndex());
        return viewColumnIndex < 0 ? "" : this.adapter.getColumnName(viewColumnIndex);
    }

    public int convertRowIndexToModel(int row) {
        if (this.order == 0 || this.pipeline == null) {
            return this.translateToPreviousFilter(row);
        }
        return this.pipeline.convertRowIndexToModel(this, this.translateToPreviousFilter(row));
    }

    public int convertRowIndexToView(int row) {
        if (this.order == 0 || this.pipeline == null) {
            return this.translateFromPreviousFilter(row);
        }
        return this.translateFromPreviousFilter(this.pipeline.convertRowIndexToView(this, row));
    }

    public abstract int getSize();

    protected abstract int translateFromPreviousFilter(int var1);

    protected abstract int translateToPreviousFilter(int var1);

    public Object getValueAt(int row, int column) {
        if (this.order == 0 || this.pipeline == null) {
            return this.adapter.getValueAt(this.translateToPreviousFilter(row), this.adapter.modelToView(column));
        }
        return this.pipeline.getInputValueFor(this, this.translateToPreviousFilter(row), column);
    }

    public void setValueAt(Object aValue, int row, int column) {
        if (this.order == 0 || this.pipeline == null) {
            this.adapter.setValueAt(aValue, this.translateToPreviousFilter(row), this.adapter.modelToView(column));
        } else {
            this.pipeline.setInputValueFor(aValue, this, this.translateToPreviousFilter(row), column);
        }
    }

    public boolean isCellEditable(int row, int column) {
        if (this.order == 0 || this.pipeline == null) {
            return this.adapter.isCellEditable(row, this.adapter.modelToView(column));
        }
        return this.pipeline.isInputEditableFor(this, row, column);
    }

    protected int getInputSize() {
        return this.pipeline == null ? (this.adapter == null ? 0 : this.adapter.getRowCount()) : this.pipeline.getInputSize(this);
    }

    protected Object getInputValue(int row, int column) {
        if (this.pipeline != null) {
            return this.pipeline.getInputValueFor(this, row, column);
        }
        if (this.adapter != null) {
            return this.adapter.getValueAt(row, this.adapter.modelToView(column));
        }
        return null;
    }
}

