/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swing.table;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import org.jdesktop.swing.JXTable;
import org.jdesktop.swing.decorator.Sorter;
import org.jdesktop.swing.icon.SortArrowIcon;

public class ColumnHeaderRenderer
extends JPanel
implements TableCellRenderer {
    private static TableCellRenderer sharedInstance = null;
    private static Icon defaultDownIcon = new SortArrowIcon(false);
    private static Icon defaultUpIcon = new SortArrowIcon(true);
    private static Border defaultMarginBorder = new EmptyBorder(2, 2, 2, 2);
    private Icon downIcon = defaultDownIcon;
    private Icon upIcon = defaultUpIcon;
    private JLabel label = new JLabel("", 0);
    private JLabel arrow = new JLabel(null, 0);
    private boolean antiAliasedText = false;
    private boolean backgroundSet = false;
    private boolean foregroundSet = false;
    private boolean fontSet = false;

    public static TableCellRenderer getSharedInstance() {
        if (sharedInstance == null) {
            sharedInstance = new ColumnHeaderRenderer();
        }
        return sharedInstance;
    }

    public ColumnHeaderRenderer() {
        this.setLayout(new BorderLayout());
        Font boldFont = this.label.getFont().deriveFont(1);
        this.label.setFont(boldFont);
        this.label.setOpaque(false);
        this.add(this.label);
        this.add((Component)this.arrow, "East");
    }

    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int rowIndex, int columnIndex) {
        this.label.setText(value == null ? "" : value.toString());
        JTableHeader header = table.getTableHeader();
        if (header != null) {
            if (!this.foregroundSet) {
                this.setForeground(header.getForeground());
                this.foregroundSet = false;
            }
            if (!this.backgroundSet) {
                this.setBackground(header.getBackground());
                this.backgroundSet = false;
            }
            if (!this.fontSet) {
                this.setFont(header.getFont());
                this.fontSet = false;
            }
        }
        if (table instanceof JXTable) {
            Sorter sorter = ((JXTable)table).getSorter(columnIndex);
            if (sorter == null) {
                this.arrow.setIcon(null);
            } else {
                this.arrow.setIcon(sorter.isAscending() ? this.upIcon : this.downIcon);
            }
        }
        this.setBorder(new CompoundBorder(UIManager.getBorder("TableHeader.cellBorder"), defaultMarginBorder));
        return this;
    }

    public void setAntiAliasedText(boolean antiAlias) {
        this.antiAliasedText = antiAlias;
    }

    public boolean getAntiAliasedText() {
        return this.antiAliasedText;
    }

    public void setBackground(Color background) {
        this.backgroundSet = true;
        super.setBackground(background);
    }

    public void setForeground(Color foreground) {
        this.foregroundSet = true;
        super.setForeground(foreground);
        if (this.label != null) {
            this.label.setForeground(foreground);
        }
    }

    public void setFont(Font font) {
        this.fontSet = true;
        super.setFont(font);
        if (this.label != null) {
            this.label.setFont(font);
        }
    }

    public void setDownIcon(Icon icon) {
        this.downIcon = icon;
    }

    public Icon getDownIcon() {
        return this.downIcon;
    }

    public void setUpIcon(Icon icon) {
        this.upIcon = icon;
    }

    public Icon getUpIcon() {
        return this.upIcon;
    }

    public void setHorizontalAlignment(int alignment) {
        this.label.setHorizontalAlignment(alignment);
    }

    public int getHorizontalAlignment() {
        return this.label.getHorizontalAlignment();
    }

    public void setHorizontalTextPosition(int textPosition) {
        this.label.setHorizontalTextPosition(textPosition);
    }

    public int getHorizontalTextPosition() {
        return this.label.getHorizontalTextPosition();
    }

    public void setIcon(Icon icon) {
        this.label.setIcon(icon);
    }

    public Icon getIcon() {
        return this.label.getIcon();
    }

    public void setIconTextGap(int iconTextGap) {
        this.label.setIconTextGap(iconTextGap);
    }

    public int getIconTextGap() {
        return this.label.getIconTextGap();
    }

    public void setVerticalAlignment(int alignment) {
        this.label.setVerticalAlignment(alignment);
    }

    public int getVerticalAlignment() {
        return this.label.getVerticalAlignment();
    }

    public void setVerticalTextPosition(int textPosition) {
        this.label.setVerticalTextPosition(textPosition);
    }

    public int getVerticalTextPosition() {
        return this.label.getVerticalTextPosition();
    }

    public void paint(Graphics g) {
        if (this.antiAliasedText) {
            Graphics2D g2 = (Graphics2D)g;
            Object save = g2.getRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING);
            g2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            super.paint(g2);
            g2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, save);
        } else {
            super.paint(g);
        }
    }
}

