/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swing.table;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.Iterator;
import org.jdesktop.swing.data.Converter;

public class TabularDataMetaData {
    private Column[] columns;
    private PropertyChangeSupport pcs = new PropertyChangeSupport(this);
    static /* synthetic */ Class class$0;

    public TabularDataMetaData() {
        this(0);
    }

    public TabularDataMetaData(int columnCount) {
        this.setColumnCount(columnCount);
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.removePropertyChangeListener(listener);
    }

    public void setColumnCount(int columnCount) {
        int oldColumnCount = this.columns != null ? this.columns.length : 0;
        this.columns = new Column[columnCount];
        int i = 0;
        while (i < columnCount) {
            String string = "column" + i;
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = Class.forName("java.lang.String");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            this.columns[i] = new Column(string, clazz, true);
            ++i;
        }
        this.pcs.firePropertyChange("columnCount", oldColumnCount, columnCount);
    }

    public int getColumnCount() {
        return this.columns.length;
    }

    public int getColumnIndex(String name) {
        int index = 0;
        int i = 0;
        while (i < this.columns.length) {
            if (this.columns[i].name.equals(name)) {
                return i + 1;
            }
            ++i;
        }
        return index;
    }

    public String getColumnName(int columnIndex) {
        return this.columns[columnIndex - 1].name;
    }

    public void setColumnName(int columnIndex, String columnName) {
        String oldColumnName = this.columns[columnIndex - 1].name;
        this.columns[columnIndex - 1].name = columnName;
        this.pcs.firePropertyChange("columnName" + columnIndex, oldColumnName, columnName);
    }

    public String getColumnLabel(int columnIndex) {
        return this.columns[columnIndex - 1].label;
    }

    public void setColumnLabel(int columnIndex, String columnLabel) {
        String oldColumnLabel = this.columns[columnIndex - 1].label;
        this.columns[columnIndex - 1].label = columnLabel;
        this.pcs.firePropertyChange("columnLabel" + columnIndex, oldColumnLabel, columnLabel);
    }

    public Class getColumnClass(int columnIndex) {
        return this.columns[columnIndex - 1].klass;
    }

    public void setColumnClass(int columnIndex, Class columnClass) {
        Class oldColumnClass = this.columns[columnIndex - 1].klass;
        this.columns[columnIndex - 1].klass = columnClass;
        this.pcs.firePropertyChange("columnClass" + columnIndex, oldColumnClass, columnClass);
    }

    public void setColumnDisplaySize(int columnIndex, int numChars) {
        this.columns[columnIndex - 1].displayLength = numChars;
    }

    public int getColumnDisplaySize(int columnIndex) {
        return this.columns[columnIndex - 1].displayLength;
    }

    public boolean isColumnWritable(int columnIndex) {
        return this.columns[columnIndex - 1].writable;
    }

    public void setColumnWritable(int columnIndex, boolean writable) {
        this.columns[columnIndex - 1].writable = writable;
    }

    public boolean isColumnNullable(int columnIndex) {
        return this.columns[columnIndex - 1].nullable;
    }

    public void setColumnNullable(int columnIndex, boolean nullable) {
        this.columns[columnIndex - 1].nullable = nullable;
    }

    public Object getColumnMinimum(int columnIndex) {
        return this.columns[columnIndex - 1].minimum;
    }

    public void setColumnMinimum(int columnIndex, Object minimum) {
        this.columns[columnIndex - 1].minimum = minimum;
    }

    public Object getColumnMaximum(int columnIndex) {
        return this.columns[columnIndex - 1].maximum;
    }

    public void setColumnMaximum(int columnIndex, Object maximum) {
        this.columns[columnIndex - 1].maximum = maximum;
    }

    public Iterator getColumnValues(int columnIndex) {
        final Object[] values = new Object[this.columns[columnIndex - 1].values.length];
        System.arraycopy(this.columns[columnIndex - 1].values, 0, values, 0, this.columns[columnIndex - 1].values.length);
        return new Iterator(){
            int current = 0;

            public boolean hasNext() {
                return this.current < values.length;
            }

            public Object next() {
                return values[this.current++];
            }

            public void remove() {
            }
        };
    }

    public void setColumnValues(int columnIndex, Object[] values) {
        Object[] newValues = new Object[values.length];
        System.arraycopy(values, 0, newValues, 0, values.length);
        this.columns[columnIndex - 1].values = newValues;
    }

    public void setColumnConverter(int columnIndex, Converter converter) {
        this.columns[columnIndex - 1].converter = converter;
    }

    public Converter getColumnConverter(int columnIndex) {
        return this.columns[columnIndex - 1].converter;
    }

    private class Column {
        public String name;
        public Class klass;
        public String label;
        public Converter converter;
        public boolean writable = false;
        public boolean nullable = false;
        public int displayLength = -1;
        public Object minimum;
        public Object maximum;
        public Object[] values;

        public Column(String name, Class klass, boolean writable) {
            this.name = name;
            this.klass = klass;
            this.writable = writable;
        }
    }
}

