/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swing.treetable;

import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.util.EventObject;
import javax.swing.DefaultCellEditor;
import javax.swing.Icon;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreeCellRenderer;
import org.jdesktop.swing.JXTreeTable;

public class TreeTableCellEditor
extends DefaultCellEditor {
    private final JXTreeTable treeTable;
    private final JTree tree;

    public TreeTableCellEditor(JXTreeTable treeTable, JTree tree) {
        super(new TreeTableTextField());
        if (treeTable == null) {
            throw new IllegalArgumentException("null treeTable");
        }
        if (tree == null) {
            throw new IllegalArgumentException("null tree");
        }
        this.treeTable = treeTable;
        this.tree = tree;
    }

    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        Component component = super.getTableCellEditorComponent(table, value, isSelected, row, column);
        Rectangle bounds = this.tree.getRowBounds(row);
        int offset = bounds.x;
        TreeCellRenderer tcr = this.tree.getCellRenderer();
        if (tcr instanceof DefaultTreeCellRenderer) {
            Object node = this.tree.getPathForRow(row).getLastPathComponent();
            Icon icon = this.tree.getModel().isLeaf(node) ? ((DefaultTreeCellRenderer)tcr).getLeafIcon() : (this.tree.isExpanded(row) ? ((DefaultTreeCellRenderer)tcr).getOpenIcon() : ((DefaultTreeCellRenderer)tcr).getClosedIcon());
            if (icon != null) {
                offset += ((DefaultTreeCellRenderer)tcr).getIconTextGap() + icon.getIconWidth();
            }
        }
        ((TreeTableTextField)this.getComponent()).offset = offset;
        return component;
    }

    public boolean isCellEditable(EventObject e) {
        if (e == null) {
            return true;
        }
        if (e instanceof MouseEvent) {
            return ((MouseEvent)e).getClickCount() >= this.clickCountToStart;
        }
        return false;
    }

    static class TreeTableTextField
    extends JTextField {
        int offset;

        TreeTableTextField() {
        }

        public void reshape(int x, int y, int width, int height) {
            int newOffset = this.offset - this.getInsets().left;
            super.reshape(x + newOffset, y, width - newOffset, height);
        }
    }
}

