/*
 * Decompiled with CFR 0.152.
 */
package kdweibo4j;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import kdweibo4j.ActivityComment;
import kdweibo4j.Picture;
import kdweibo4j.WeiboException;
import kdweibo4j.WeiboResponse;
import kdweibo4j.http.Response;
import kdweibo4j.org.json.JSONArray;
import kdweibo4j.org.json.JSONException;
import kdweibo4j.org.json.JSONObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Activity
extends WeiboResponse
implements Serializable {
    private static final long serialVersionUID = 4069573686251578633L;
    public String id;
    public String type;
    public String title;
    public String verb;
    public Date published;
    public Date updated;
    public String ownerId;
    public String ownerName;
    public String photoId;
    public String target;
    public List<ActivityComment> comments;
    public List<Picture> pictures;
    public int commentCount;
    public String content;

    Activity(Response res) throws WeiboException {
        super(res);
        JSONObject json = res.asJSONObject();
        try {
            JSONObject actorJson;
            this.id = json.getString("id");
            this.content = json.getString("content");
            this.type = json.getString("type");
            this.published = new Date(json.getLong("published"));
            this.updated = new Date(json.getLong("updated"));
            this.title = json.getString("title");
            this.verb = json.getString("verb");
            this.title = json.getString("title");
            JSONObject targetJson = json.getJSONObject("target");
            if (targetJson != null) {
                this.target = targetJson.getString("id");
            }
            if ((actorJson = json.getJSONObject("actor")) != null) {
                this.ownerId = actorJson.getString("id");
                this.ownerName = actorJson.getString("name");
                this.photoId = actorJson.getString("photoId");
            }
            this.commentCount = json.getInt("commentCount");
            if (json.get("comments") instanceof JSONArray) {
                JSONArray commentsJsonList = json.getJSONArray("comments");
                this.comments = ActivityComment.constructList(commentsJsonList);
            }
            if (json.get("attachments") instanceof JSONArray) {
                JSONArray picturesJsonList = json.getJSONArray("attachments");
                this.pictures = Picture.constructList(picturesJsonList);
            }
        }
        catch (JSONException je) {
            throw new WeiboException(String.valueOf(je.getMessage()) + ":" + json.toString(), je);
        }
    }

    Activity(JSONObject json) throws WeiboException {
        try {
            JSONObject actorJson;
            this.id = json.getString("id");
            this.content = json.getString("content");
            this.type = json.getString("type");
            this.published = new Date(json.getLong("published"));
            this.updated = new Date(json.getLong("updated"));
            this.title = json.getString("title");
            this.verb = json.getString("verb");
            this.title = json.getString("title");
            JSONObject targetJson = json.getJSONObject("target");
            if (targetJson != null) {
                this.target = targetJson.getString("id");
            }
            if ((actorJson = json.getJSONObject("actor")) != null) {
                this.ownerId = actorJson.getString("id");
                this.ownerName = actorJson.getString("name");
                this.photoId = actorJson.getString("photoId");
            }
            this.commentCount = json.getInt("commentCount");
            if (json.get("comments") instanceof JSONArray) {
                JSONArray commentsJsonList = json.getJSONArray("comments");
                this.comments = ActivityComment.constructList(commentsJsonList);
            }
            if (json.get("attachments") instanceof JSONArray) {
                JSONArray picturesJsonList = json.getJSONArray("attachments");
                this.pictures = Picture.constructList(picturesJsonList);
            }
        }
        catch (JSONException je) {
            throw new WeiboException(String.valueOf(je.getMessage()) + ":" + json.toString(), je);
        }
    }

    static List<Activity> constructList(Response res) throws WeiboException {
        JSONArray list = res.asJSONArray();
        try {
            int size = list.length();
            ArrayList<Activity> activities = new ArrayList<Activity>(size);
            int i = 0;
            while (i < size) {
                activities.add(new Activity(list.getJSONObject(i)));
                ++i;
            }
            return activities;
        }
        catch (JSONException je) {
            throw new WeiboException(String.valueOf(je.getMessage()) + ":" + list.toString(), je);
        }
    }
}

