/*
 * Decompiled with CFR 0.152.
 */
package kdweibo4j;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import kdweibo4j.WeiboException;
import kdweibo4j.http.Response;
import kdweibo4j.org.json.JSONArray;
import kdweibo4j.org.json.JSONException;
import kdweibo4j.org.json.JSONObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Count
implements Serializable {
    private static final long serialVersionUID = 9076424494907778181L;
    private String id;
    private long comments;
    private long rt;
    private long dm;
    private long mentions;
    private long followers;
    private long like;
    private long favorite;

    public Count(JSONObject json) throws WeiboException, JSONException {
        this.id = json.getString("id");
        this.comments = json.getLong("comments");
        this.rt = json.getLong("rt");
        this.dm = json.getLong("dm");
        this.mentions = json.getLong("mentions");
        this.followers = json.getLong("followers");
        this.like = json.getLong("like");
        this.favorite = json.getLong("favorite");
    }

    static List<Count> constructCounts(Response res) throws WeiboException {
        try {
            JSONArray list = res.asJSONArray();
            int size = list.length();
            ArrayList<Count> counts = new ArrayList<Count>(size);
            int i = 0;
            while (i < size) {
                counts.add(new Count(list.getJSONObject(i)));
                ++i;
            }
            return counts;
        }
        catch (JSONException jsone) {
            throw new WeiboException(jsone);
        }
        catch (WeiboException te) {
            throw te;
        }
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        return obj instanceof Count && ((Count)obj).id == this.id;
    }

    public long getComments() {
        return this.comments;
    }

    public long getRt() {
        return this.rt;
    }

    public long getDm() {
        return this.dm;
    }

    public long getMentions() {
        return this.mentions;
    }

    public long getFollowers() {
        return this.followers;
    }

    public long getLike() {
        return this.like;
    }

    public void setLike(long like) {
        this.like = like;
    }

    public long getFavorite() {
        return this.favorite;
    }

    public void setFavorite(long favorite) {
        this.favorite = favorite;
    }

    public String toString() {
        return "Count{ id=" + this.id + ", comments=" + this.comments + ", rt=" + this.rt + ", dm=" + this.dm + ", mentions=" + this.mentions + ", followers=" + this.followers + ", favorite=" + this.favorite + ", like=" + this.like + '}';
    }
}

