/*
 * Decompiled with CFR 0.152.
 */
package kdweibo4j;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import kdweibo4j.WeiboException;
import kdweibo4j.WeiboResponse;
import kdweibo4j.http.Response;
import kdweibo4j.org.json.JSONArray;
import kdweibo4j.org.json.JSONException;
import kdweibo4j.org.json.JSONObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Group
extends WeiboResponse
implements Serializable {
    private static final long serialVersionUID = -3517566426034716779L;
    public String id;
    public String name;
    public String profile_image_url;
    public String description;
    public String bulletin;

    Group(Response res) throws WeiboException {
        super(res);
        JSONObject json = res.asJSONObject();
        try {
            this.id = json.getString("id");
            this.name = json.getString("name");
            this.profile_image_url = json.getString("profile_image_url");
            this.description = json.getString("description");
            this.bulletin = json.getString("bulletin");
        }
        catch (JSONException je) {
            throw new WeiboException(String.valueOf(je.getMessage()) + ":" + json.toString(), je);
        }
    }

    Group(JSONObject json) throws WeiboException {
        try {
            this.id = json.getString("id");
            this.name = json.getString("name");
            this.profile_image_url = json.getString("profile_image_url");
            this.description = json.getString("description");
            this.bulletin = json.getString("bulletin");
        }
        catch (JSONException je) {
            throw new WeiboException(String.valueOf(je.getMessage()) + ":" + json.toString(), je);
        }
    }

    static List<Group> constructList(Response res) throws WeiboException {
        JSONArray list = res.asJSONArray();
        try {
            int size = list.length();
            ArrayList<Group> groups = new ArrayList<Group>(size);
            int i = 0;
            while (i < size) {
                groups.add(new Group(list.getJSONObject(i)));
                ++i;
            }
            return groups;
        }
        catch (JSONException je) {
            throw new WeiboException(String.valueOf(je.getMessage()) + ":" + list.toString(), je);
        }
    }
}

