/*
 * Decompiled with CFR 0.152.
 */
package kdweibo4j;

import java.io.Serializable;
import java.util.ArrayList;
import kdweibo4j.ListObjectWapper;
import kdweibo4j.User;
import kdweibo4j.WeiboException;
import kdweibo4j.WeiboResponse;
import kdweibo4j.http.Response;
import kdweibo4j.org.json.JSONArray;
import kdweibo4j.org.json.JSONException;
import kdweibo4j.org.json.JSONObject;

public class ListObject
extends WeiboResponse
implements Serializable {
    private static final long serialVersionUID = 4208232205515192208L;
    private long id;
    private String name;
    private String fullName;
    private String slug;
    private String description;
    private String uri;
    private int subscriberCount;
    private int memberCount;
    private String mode;
    private User user;

    ListObject(JSONObject json) throws WeiboException {
        try {
            this.id = json.getLong("id");
            this.name = json.getString("name");
            this.fullName = json.getString("full_name");
            this.slug = json.getString("slug");
            this.description = json.getString("description");
            this.subscriberCount = json.getInt("subscriber_count");
            this.memberCount = json.getInt("member_count");
            this.uri = json.getString("uri");
            this.mode = json.getString("mode");
            if (!json.isNull("user")) {
                this.user = new User(json.getJSONObject("user"));
            }
        }
        catch (JSONException jsone) {
            throw new WeiboException(String.valueOf(jsone.getMessage()) + ":" + json.toString(), jsone);
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getFullName() {
        return this.fullName;
    }

    public void setFullName(String fullName) {
        this.fullName = fullName;
    }

    public String getSlug() {
        return this.slug;
    }

    public void setSlug(String slug) {
        this.slug = slug;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getUri() {
        return this.uri;
    }

    public void setUri(String uri) {
        this.uri = uri;
    }

    public int getSubscriberCount() {
        return this.subscriberCount;
    }

    public void setSubscriberCount(int subscriberCount) {
        this.subscriberCount = subscriberCount;
    }

    public int getMemberCount() {
        return this.memberCount;
    }

    public void setMemberCount(int memberCount) {
        this.memberCount = memberCount;
    }

    public void setId(long id) {
        this.id = id;
    }

    public long getId() {
        return this.id;
    }

    public String getMode() {
        return this.mode;
    }

    public void setMode(String mode) {
        this.mode = mode;
    }

    public User getUser() {
        return this.user;
    }

    public void setUser(User user) {
        this.user = user;
    }

    static ListObjectWapper constructListObjects(Response res) throws WeiboException {
        JSONObject jsonLists = res.asJSONObject();
        try {
            JSONArray list = jsonLists.getJSONArray("lists");
            int size = list.length();
            ArrayList<ListObject> listObjects = new ArrayList<ListObject>(size);
            int i = 0;
            while (i < size) {
                listObjects.add(new ListObject(list.getJSONObject(i)));
                ++i;
            }
            long previousCursor = jsonLists.getLong("previous_curosr");
            long nextCursor = jsonLists.getLong("next_cursor");
            if (nextCursor == -1L) {
                nextCursor = jsonLists.getLong("nextCursor");
            }
            return new ListObjectWapper(listObjects, previousCursor, nextCursor);
        }
        catch (JSONException jsone) {
            throw new WeiboException(jsone);
        }
    }

    public int hashCode() {
        return (int)this.id;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        return obj instanceof ListObject && ((ListObject)obj).id == this.id;
    }

    public String toString() {
        return "ListObject{id=" + this.id + ", name='" + this.name + '\'' + ", fullName='" + this.fullName + '\'' + ", slug='" + this.slug + '\'' + ", description='" + this.description + '\'' + ", subscriberCount=" + this.subscriberCount + ", memberCount=" + this.memberCount + ", mode='" + this.mode + "', uri='" + this.uri + '\'' + ", user='" + this.user.toString() + "'}";
    }
}

