/*
 * Decompiled with CFR 0.152.
 */
package kdweibo4j;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import kdweibo4j.WeiboException;
import kdweibo4j.WeiboResponse;
import kdweibo4j.org.json.JSONArray;
import kdweibo4j.org.json.JSONException;
import kdweibo4j.org.json.JSONObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Picture
extends WeiboResponse
implements Serializable {
    private static final long serialVersionUID = 3746736775845364985L;
    public String thumbnail_pic;
    public String bmiddle_pic;
    public String original_pic;
    public String contentType;
    public String fileId;
    public String fileName;

    Picture(JSONObject json) throws WeiboException {
        try {
            this.bmiddle_pic = json.getString("bmiddle_pic");
            this.original_pic = json.getString("original_pic");
            this.thumbnail_pic = json.getString("thumbnail_pic");
        }
        catch (JSONException je) {
            throw new WeiboException(String.valueOf(je.getMessage()) + ":" + json.toString(), je);
        }
    }

    public static List<Picture> constructList(JSONArray picturesJsonList) throws WeiboException, JSONException {
        if (picturesJsonList != null) {
            int size = picturesJsonList.length();
            ArrayList<Picture> pics = new ArrayList<Picture>(size);
            int i = 0;
            while (i < size) {
                JSONObject json = picturesJsonList.getJSONObject(i);
                String _contentType = json.getString("contentType");
                if (_contentType != null && _contentType.startsWith("image")) {
                    pics.add(new Picture(picturesJsonList.getJSONObject(i)));
                }
                ++i;
            }
            return pics;
        }
        return null;
    }
}

