/*
 * Decompiled with CFR 0.152.
 */
package kdweibo4j;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import kdweibo4j.User;
import kdweibo4j.WeiboException;
import kdweibo4j.WeiboResponse;
import kdweibo4j.http.Response;
import kdweibo4j.org.json.JSONArray;
import kdweibo4j.org.json.JSONException;
import kdweibo4j.org.json.JSONObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RetweetDetails
extends WeiboResponse
implements Serializable {
    private long retweetId;
    private Date retweetedAt;
    private User retweetingUser;
    static final long serialVersionUID = 1957982268696560598L;

    RetweetDetails(JSONObject json) throws WeiboException {
        this.init(json);
    }

    private void init(JSONObject json) throws WeiboException {
        try {
            this.retweetId = json.getInt("retweetId");
            this.retweetedAt = RetweetDetails.parseDate(json.getString("retweetedAt"), "EEE MMM dd HH:mm:ss z yyyy");
            this.retweetingUser = new User(json.getJSONObject("user"));
        }
        catch (JSONException jsone) {
            throw new WeiboException(String.valueOf(jsone.getMessage()) + ":" + json.toString(), jsone);
        }
    }

    public long getRetweetId() {
        return this.retweetId;
    }

    public Date getRetweetedAt() {
        return this.retweetedAt;
    }

    public User getRetweetingUser() {
        return this.retweetingUser;
    }

    static List<RetweetDetails> createRetweetDetails(Response res) throws WeiboException {
        try {
            JSONArray list = res.asJSONArray();
            int size = list.length();
            ArrayList<RetweetDetails> retweets = new ArrayList<RetweetDetails>(size);
            int i = 0;
            while (i < size) {
                retweets.add(new RetweetDetails(list.getJSONObject(i)));
                ++i;
            }
            return retweets;
        }
        catch (JSONException jsone) {
            throw new WeiboException(jsone);
        }
        catch (WeiboException te) {
            throw te;
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof RetweetDetails)) {
            return false;
        }
        RetweetDetails that = (RetweetDetails)o;
        return this.retweetId == that.retweetId;
    }

    public int hashCode() {
        int result = (int)(this.retweetId ^ this.retweetId >>> 32);
        result = 31 * result + this.retweetedAt.hashCode();
        result = 31 * result + this.retweetingUser.hashCode();
        return result;
    }

    public String toString() {
        return "RetweetDetails{retweetId=" + this.retweetId + ", retweetedAt=" + this.retweetedAt + ", retweetingUser=" + this.retweetingUser + '}';
    }
}

