/*
 * Decompiled with CFR 0.152.
 */
package kdweibo4j;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import kdweibo4j.Weibo;
import kdweibo4j.WeiboException;
import kdweibo4j.WeiboResponse;
import kdweibo4j.http.Response;
import kdweibo4j.org.json.JSONArray;
import kdweibo4j.org.json.JSONException;
import kdweibo4j.org.json.JSONObject;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Tag
extends WeiboResponse
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String id;
    private String value;

    public Tag(Response res, Element elem) throws WeiboException {
        Tag.ensureRootNodeNameIs("tag", elem);
        this.id = Tag.getChildText("id", elem);
        this.value = Tag.getChildText("value", elem);
    }

    public Tag(Response res, Element elem, Weibo weibo, String str) throws WeiboException {
        Tag.ensureRootNodeNameIs("tagid", elem);
        this.id = elem.getNodeName();
        this.value = elem.getTextContent();
    }

    public Tag(Response res, Element elem, Weibo weibo) throws WeiboException {
        Tag.ensureRootNodeNameIs("tagid", elem);
        this.id = elem.getNodeName();
        this.value = elem.getTextContent();
    }

    public Tag(JSONObject json) throws WeiboException, JSONException {
        if (json.getString("id") == null || json.getString("id").length() <= 0) {
            Iterator i = json.keys();
            while (i.hasNext()) {
                this.id = (String)i.next();
                this.value = json.getString(this.id);
            }
        } else {
            this.id = json.getString("id");
            this.value = json.getString("value");
        }
    }

    public static List<Tag> constructTags(Response res, Weibo weibo) throws WeiboException {
        Document doc = res.asDocument();
        if (Tag.isRootNodeNilClasses(doc)) {
            return new ArrayList<Tag>(0);
        }
        try {
            Tag.ensureRootNodeNameIs("tags", doc);
            NodeList list = doc.getDocumentElement().getElementsByTagName("tag");
            int size = list.getLength();
            ArrayList<Tag> tags = new ArrayList<Tag>(size);
            int i = 0;
            while (i < size) {
                tags.add(new Tag(res, (Element)list.item(i)));
                ++i;
            }
            return tags;
        }
        catch (WeiboException te) {
            Tag.ensureRootNodeNameIs("nil-classes", doc);
            return new ArrayList<Tag>(0);
        }
    }

    public static List<Tag> createTags(Response res, Weibo weibo) throws WeiboException {
        Document doc = res.asDocument();
        if (Tag.isRootNodeNilClasses(doc)) {
            return new ArrayList<Tag>(0);
        }
        try {
            Tag.ensureRootNodeNameIs("tagids", doc);
            NodeList list = doc.getDocumentElement().getElementsByTagName("tagid");
            int size = list.getLength();
            ArrayList<Tag> tags = new ArrayList<Tag>(size);
            int i = 0;
            while (i < size) {
                tags.add(new Tag(res, (Element)list.item(i), null));
                ++i;
            }
            return tags;
        }
        catch (WeiboException te) {
            Tag.ensureRootNodeNameIs("nil-classes", doc);
            return new ArrayList<Tag>(0);
        }
    }

    public static List<Tag> destroyTags(Response res, Weibo weibo) throws WeiboException {
        Document doc = res.asDocument();
        if (Tag.isRootNodeNilClasses(doc)) {
            return new ArrayList<Tag>(0);
        }
        try {
            Tag.ensureRootNodeNameIs("tags", doc);
            NodeList list = doc.getDocumentElement().getElementsByTagName("tagid");
            int size = list.getLength();
            ArrayList<Tag> tags = new ArrayList<Tag>(size);
            int i = 0;
            while (i < size) {
                tags.add(new Tag(res, (Element)list.item(i), null, null));
                ++i;
            }
            return tags;
        }
        catch (WeiboException te) {
            Tag.ensureRootNodeNameIs("nil-classes", doc);
            return new ArrayList<Tag>(0);
        }
    }

    static List<Tag> constructTags(Response res) throws WeiboException {
        try {
            JSONArray list = res.asJSONArray();
            int size = list.length();
            ArrayList<Tag> tags = new ArrayList<Tag>(size);
            int i = 0;
            while (i < size) {
                tags.add(new Tag(list.getJSONObject(i)));
                ++i;
            }
            return tags;
        }
        catch (JSONException jsone) {
            throw new WeiboException(jsone);
        }
        catch (WeiboException te) {
            throw te;
        }
    }

    public int hashCode() {
        return Integer.parseInt(this.id);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        return obj instanceof Tag && ((Tag)obj).id == this.id;
    }

    public String getId() {
        return this.id;
    }

    public String getValue() {
        return this.value;
    }

    public String toString() {
        return "tags{ " + this.id + "," + this.value + '}';
    }
}

