/*
 * Decompiled with CFR 0.152.
 */
package kdweibo4j;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import kdweibo4j.Trend;
import kdweibo4j.WeiboException;
import kdweibo4j.WeiboResponse;
import kdweibo4j.http.Response;
import kdweibo4j.org.json.JSONArray;
import kdweibo4j.org.json.JSONException;
import kdweibo4j.org.json.JSONObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Trends
extends WeiboResponse
implements Comparable<Trends> {
    private Date asOf;
    private Date trendAt;
    private Trend[] trends;
    private static final long serialVersionUID = -7151479143843312309L;

    @Override
    public int compareTo(Trends that) {
        return this.trendAt.compareTo(that.trendAt);
    }

    Trends(Response res, Date asOf, Date trendAt, Trend[] trends) throws WeiboException {
        super(res);
        this.asOf = asOf;
        this.trendAt = trendAt;
        this.trends = trends;
    }

    static List<Trends> constructTrendsList(Response res) throws WeiboException {
        try {
            JSONArray list = res.asJSONArray();
            ArrayList<Trends> trends = new ArrayList<Trends>();
            Trends item = new Trends(res, null, null, Trends.jsonArrayToTrendArray(list));
            trends.add(item);
            return trends;
        }
        catch (JSONException jsone) {
            throw new WeiboException(jsone);
        }
        catch (WeiboException te) {
            throw te;
        }
    }

    static Trends constructTrends(Response res) throws WeiboException {
        try {
            JSONArray list = res.asJSONArray();
            Trends item = new Trends(res, null, null, Trends.jsonArrayToTrendArray(list));
            return item;
        }
        catch (JSONException jsone) {
            throw new WeiboException(jsone);
        }
        catch (WeiboException te) {
            throw te;
        }
    }

    private static Date parseDate(String asOfStr) throws WeiboException {
        Date parsed = asOfStr.length() == 10 ? new Date(Long.parseLong(asOfStr) * 1000L) : WeiboResponse.parseDate(asOfStr, "EEE, d MMM yyyy HH:mm:ss z");
        return parsed;
    }

    private static Trend[] jsonArrayToTrendArray(JSONArray array) throws JSONException {
        Trend[] trends = new Trend[array.length()];
        int i = 0;
        while (i < array.length()) {
            JSONObject trend = array.getJSONObject(i);
            trends[i] = new Trend(trend);
            ++i;
        }
        return trends;
    }

    public Trend[] getTrends() {
        return this.trends;
    }

    public Date getAsOf() {
        return this.asOf;
    }

    public Date getTrendAt() {
        return this.trendAt;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Trends)) {
            return false;
        }
        Trends trends1 = (Trends)o;
        if (this.asOf != null ? !this.asOf.equals(trends1.asOf) : trends1.asOf != null) {
            return false;
        }
        if (this.trendAt != null ? !this.trendAt.equals(trends1.trendAt) : trends1.trendAt != null) {
            return false;
        }
        return Arrays.equals(this.trends, trends1.trends);
    }

    public int hashCode() {
        int result = this.asOf != null ? this.asOf.hashCode() : 0;
        result = 31 * result + (this.trendAt != null ? this.trendAt.hashCode() : 0);
        result = 31 * result + (this.trends != null ? Arrays.hashCode(this.trends) : 0);
        return result;
    }

    public String toString() {
        return "Trends{asOf=" + this.asOf + ", trendAt=" + this.trendAt + ", trends=" + (this.trends == null ? null : Arrays.asList(this.trends)) + '}';
    }
}

