/*
 * Decompiled with CFR 0.152.
 */
package kdweibo4j;

import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import kdweibo4j.DirectMessage;
import kdweibo4j.UserWapper;
import kdweibo4j.Weibo;
import kdweibo4j.WeiboException;
import kdweibo4j.WeiboResponse;
import kdweibo4j.http.Response;
import kdweibo4j.org.json.JSONArray;
import kdweibo4j.org.json.JSONException;
import kdweibo4j.org.json.JSONObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class User
extends WeiboResponse
implements Serializable {
    static final String[] POSSIBLE_ROOT_NAMES = new String[]{"user", "sender", "recipient", "retweeting_user"};
    private Weibo weibo;
    private String id;
    private String name;
    private String screenName;
    private String location;
    private String description;
    private String profileImageUrl;
    private String url;
    private boolean isProtected;
    private int followersCount;
    private Date statusCreatedAt;
    private String statusId = null;
    private String statusText = null;
    private String statusSource = null;
    private boolean statusTruncated = false;
    private String statusInReplyToStatusId = null;
    private String statusInReplyToUserId = null;
    private boolean statusFavorited = false;
    private String statusInReplyToScreenName = null;
    private String profileBackgroundColor;
    private String profileTextColor;
    private String profileLinkColor;
    private String profileSidebarFillColor;
    private String profileSidebarBorderColor;
    private int friendsCount;
    private Date createdAt;
    private int favouritesCount;
    private int utcOffset;
    private String timeZone;
    private String profileBackgroundImageUrl;
    private String profileBackgroundTile;
    private boolean following;
    private boolean notificationEnabled;
    private int statusesCount;
    private boolean geoEnabled;
    private boolean verified;
    private boolean admin;
    public String companyId;
    public String companyName;
    public boolean publicUser;
    private static final long serialVersionUID = -6345893237975349030L;

    User(JSONObject json) throws WeiboException {
        this.init(json);
    }

    private void init(JSONObject json) throws WeiboException {
        if (json != null) {
            try {
                this.id = json.getString("id");
                this.name = json.getString("name");
                this.screenName = json.getString("screen_name");
                this.location = json.getString("location");
                this.description = json.getString("description");
                this.profileImageUrl = json.getString("profile_image_url");
                this.url = json.getString("url");
                this.isProtected = json.getBoolean("protected");
                this.followersCount = json.getInt("followers_count");
                this.admin = json.getBoolean("admin");
                this.companyId = json.getString("companyId");
                this.companyName = json.getString("companyName");
                this.publicUser = json.getBoolean("publicUser");
                this.profileBackgroundColor = json.getString("profile_background_color");
                this.profileTextColor = json.getString("profile_text_color");
                this.profileLinkColor = json.getString("profile_link_color");
                this.profileSidebarFillColor = json.getString("profile_sidebar_fill_color");
                this.profileSidebarBorderColor = json.getString("profile_sidebar_border_color");
                this.friendsCount = json.getInt("friends_count");
                this.createdAt = User.parseDate(json.getString("created_at"), "EEE MMM dd HH:mm:ss z yyyy");
                this.favouritesCount = json.getInt("favourites_count");
                this.utcOffset = User.getInt("utc_offset", json);
                this.timeZone = json.getString("time_zone");
                this.profileBackgroundImageUrl = json.getString("profile_background_image_url");
                this.profileBackgroundTile = json.getString("profile_background_tile");
                this.following = User.getBoolean("following", json);
                this.notificationEnabled = User.getBoolean("notifications", json);
                this.statusesCount = json.getInt("statuses_count");
                if (!json.isNull("status")) {
                    JSONObject status = json.getJSONObject("status");
                    this.statusCreatedAt = User.parseDate(status.getString("created_at"), "EEE MMM dd HH:mm:ss z yyyy");
                    this.statusId = status.getString("id");
                    this.statusText = status.getString("text");
                    this.statusSource = status.getString("source");
                    this.statusTruncated = status.getBoolean("truncated");
                    this.statusInReplyToStatusId = status.getString("in_reply_to_status_id");
                    this.statusInReplyToUserId = status.getString("in_reply_to_user_id");
                    this.statusFavorited = status.getBoolean("favorited");
                    this.statusInReplyToScreenName = status.getString("in_reply_to_screen_name");
                }
            }
            catch (JSONException jsone) {
                throw new WeiboException(String.valueOf(jsone.getMessage()) + ":" + json.toString(), jsone);
            }
        }
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getScreenName() {
        return this.screenName;
    }

    public String getLocation() {
        return this.location;
    }

    public String getDescription() {
        return this.description;
    }

    public URL getProfileImageURL() {
        try {
            return new URL(this.profileImageUrl);
        }
        catch (MalformedURLException ex) {
            return null;
        }
    }

    public URL getURL() {
        try {
            return new URL(this.url);
        }
        catch (MalformedURLException ex) {
            return null;
        }
    }

    public boolean isProtected() {
        return this.isProtected;
    }

    public int getFollowersCount() {
        return this.followersCount;
    }

    public DirectMessage sendDirectMessage(String text) throws WeiboException {
        return this.weibo.sendDirectMessage(this.getName(), text);
    }

    public static List<User> constructUser(Response res) throws WeiboException {
        JSONObject json = res.asJSONObject();
        try {
            JSONArray list = json.getJSONArray("users");
            int size = list.length();
            ArrayList<User> users = new ArrayList<User>(size);
            int i = 0;
            while (i < size) {
                users.add(new User(list.getJSONObject(i)));
                ++i;
            }
            return users;
        }
        catch (JSONException je) {
            throw new WeiboException(je);
        }
    }

    public static List<User> constructUsers(Response res) throws WeiboException {
        try {
            JSONArray list = res.asJSONArray();
            int size = list.length();
            ArrayList<User> users = new ArrayList<User>(size);
            int i = 0;
            while (i < size) {
                users.add(new User(list.getJSONObject(i)));
                ++i;
            }
            return users;
        }
        catch (JSONException jsone) {
            throw new WeiboException(jsone);
        }
        catch (WeiboException te) {
            throw te;
        }
    }

    public static UserWapper constructWapperUsers(Response res) throws WeiboException {
        JSONObject jsonUsers = res.asJSONObject();
        try {
            JSONArray user = jsonUsers.getJSONArray("users");
            int size = user.length();
            ArrayList<User> users = new ArrayList<User>(size);
            int i = 0;
            while (i < size) {
                users.add(new User(user.getJSONObject(i)));
                ++i;
            }
            long previousCursor = jsonUsers.getLong("previous_curosr");
            long nextCursor = jsonUsers.getLong("next_cursor");
            if (nextCursor == -1L) {
                nextCursor = jsonUsers.getLong("nextCursor");
            }
            return new UserWapper(users, previousCursor, nextCursor);
        }
        catch (JSONException jsone) {
            throw new WeiboException(jsone);
        }
    }

    static List<User> constructResult(Response res) throws WeiboException {
        JSONArray list = res.asJSONArray();
        try {
            int size = list.length();
            ArrayList<User> users = new ArrayList<User>(size);
            int i = 0;
            while (i < size) {
                users.add(new User(list.getJSONObject(i)));
                ++i;
            }
            return users;
        }
        catch (JSONException jSONException) {
            return null;
        }
    }

    public Date getStatusCreatedAt() {
        return this.statusCreatedAt;
    }

    public String getStatusId() {
        return this.statusId;
    }

    public String getStatusText() {
        return this.statusText;
    }

    public String getStatusSource() {
        return this.statusSource;
    }

    public boolean isStatusTruncated() {
        return this.statusTruncated;
    }

    public String getStatusInReplyToStatusId() {
        return this.statusInReplyToStatusId;
    }

    public String getStatusInReplyToUserId() {
        return this.statusInReplyToUserId;
    }

    public boolean isStatusFavorited() {
        return this.statusFavorited;
    }

    public String getStatusInReplyToScreenName() {
        return this.statusInReplyToUserId == null ? this.statusInReplyToScreenName : null;
    }

    public String getProfileBackgroundColor() {
        return this.profileBackgroundColor;
    }

    public String getProfileTextColor() {
        return this.profileTextColor;
    }

    public String getProfileLinkColor() {
        return this.profileLinkColor;
    }

    public String getProfileSidebarFillColor() {
        return this.profileSidebarFillColor;
    }

    public String getProfileSidebarBorderColor() {
        return this.profileSidebarBorderColor;
    }

    public int getFriendsCount() {
        return this.friendsCount;
    }

    public Date getCreatedAt() {
        return this.createdAt;
    }

    public int getFavouritesCount() {
        return this.favouritesCount;
    }

    public int getUtcOffset() {
        return this.utcOffset;
    }

    public String getTimeZone() {
        return this.timeZone;
    }

    public String getProfileBackgroundImageUrl() {
        return this.profileBackgroundImageUrl;
    }

    public String getProfileBackgroundTile() {
        return this.profileBackgroundTile;
    }

    public boolean isFollowing() {
        return this.following;
    }

    public boolean isNotifications() {
        return this.notificationEnabled;
    }

    public boolean isNotificationEnabled() {
        return this.notificationEnabled;
    }

    public int getStatusesCount() {
        return this.statusesCount;
    }

    public boolean isGeoEnabled() {
        return this.geoEnabled;
    }

    public boolean isVerified() {
        return this.verified;
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        return obj instanceof User && ((User)obj).id == this.id;
    }

    public String toString() {
        return "User{weibo=" + this.weibo + ", id=" + this.id + ", name='" + this.name + '\'' + ", screenName='" + this.screenName + '\'' + ", location='" + this.location + '\'' + ", description='" + this.description + '\'' + ", profileImageUrl='" + this.profileImageUrl + '\'' + ", url='" + this.url + '\'' + ", isProtected=" + this.isProtected + ", followersCount=" + this.followersCount + ", statusCreatedAt=" + this.statusCreatedAt + ", statusId=" + this.statusId + ", statusText='" + this.statusText + '\'' + ", statusSource='" + this.statusSource + '\'' + ", statusTruncated=" + this.statusTruncated + ", statusInReplyToStatusId=" + this.statusInReplyToStatusId + ", statusInReplyToUserId=" + this.statusInReplyToUserId + ", statusFavorited=" + this.statusFavorited + ", statusInReplyToScreenName='" + this.statusInReplyToScreenName + '\'' + ", profileBackgroundColor='" + this.profileBackgroundColor + '\'' + ", profileTextColor='" + this.profileTextColor + '\'' + ", profileLinkColor='" + this.profileLinkColor + '\'' + ", profileSidebarFillColor='" + this.profileSidebarFillColor + '\'' + ", profileSidebarBorderColor='" + this.profileSidebarBorderColor + '\'' + ", friendsCount=" + this.friendsCount + ", createdAt=" + this.createdAt + ", favouritesCount=" + this.favouritesCount + ", utcOffset=" + this.utcOffset + ", timeZone='" + this.timeZone + '\'' + ", profileBackgroundImageUrl='" + this.profileBackgroundImageUrl + '\'' + ", profileBackgroundTile='" + this.profileBackgroundTile + '\'' + ", following=" + this.following + ", notificationEnabled=" + this.notificationEnabled + ", statusesCount=" + this.statusesCount + ", geoEnabled=" + this.geoEnabled + ", verified=" + this.verified + ", admin=" + this.admin + '}';
    }

    public boolean isAdmin() {
        return this.admin;
    }
}

