/*
 * Decompiled with CFR 0.152.
 */
package kdweibo4j;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import kdweibo4j.WeiboException;
import kdweibo4j.WeiboResponse;
import kdweibo4j.http.Response;
import kdweibo4j.org.json.JSONArray;
import kdweibo4j.org.json.JSONException;
import kdweibo4j.org.json.JSONObject;

public class UserTokenList
extends WeiboResponse
implements Serializable {
    private static final long serialVersionUID = -5554226687946678110L;
    public List<TokenItem> items;

    UserTokenList(Response res) throws WeiboException {
        super(res);
        JSONArray jsonArray = res.asJSONArray();
        int size = jsonArray.length();
        this.items = new ArrayList<TokenItem>(size);
        int i = 0;
        while (i < size) {
            try {
                JSONObject jsonObject = jsonArray.getJSONObject(i);
                this.items.add(new TokenItem(jsonObject));
            }
            catch (JSONException je) {
                throw new WeiboException(String.valueOf(je.getMessage()) + ":" + jsonArray.toString(), je);
            }
            ++i;
        }
    }

    public static class TokenItem
    extends WeiboResponse
    implements Serializable {
        public String tokenString;
        public String tokenSecret;
        public String email;
        public String userId;
        public int state;
        public String msg;
        private static final long serialVersionUID = 2363066731828713162L;

        TokenItem(JSONObject json) throws WeiboException {
            try {
                this.email = json.getString("email");
                this.userId = json.getString("userId");
                this.state = json.getInt("result");
                if (this.state == 1) {
                    this.tokenString = json.getString("tokenString");
                    this.tokenSecret = json.getString("tokenSecret");
                } else {
                    this.msg = json.getString("msg");
                }
            }
            catch (JSONException je) {
                throw new WeiboException(String.valueOf(je.getMessage()) + ":" + json.toString(), je);
            }
        }
    }
}

