/*
 * Decompiled with CFR 0.152.
 */
package kdweibo4j;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import kdweibo4j.Configuration;
import kdweibo4j.Status;
import kdweibo4j.StatusListener;
import kdweibo4j.StatusStream;
import kdweibo4j.WeiboException;
import kdweibo4j.WeiboSupport;
import kdweibo4j.http.PostParameter;

public class WeiboStream
extends WeiboSupport {
    private static final boolean DEBUG = Configuration.getDebug();
    private StatusListener statusListener;
    private StreamHandlingThread handler = null;
    private int retryPerMinutes = 1;

    public WeiboStream() {
    }

    public WeiboStream(String userId, String password) {
        super(userId, password);
    }

    public WeiboStream(String userId, String password, StatusListener listener) {
        super(userId, password);
        this.statusListener = listener;
    }

    public void firehose(int count) throws WeiboException {
        this.startHandler(new StreamHandlingThread(new Object[]{count}){

            public StatusStream getStream() throws WeiboException {
                return WeiboStream.this.getFirehoseStream((Integer)this.args[0]);
            }
        });
    }

    public StatusStream getFirehoseStream(int count) throws WeiboException {
        try {
            return new StatusStream(this.http.post(String.valueOf(this.getStreamBaseURL()) + "1/statuses/firehose.json", new PostParameter[]{new PostParameter("count", String.valueOf(count))}, true));
        }
        catch (IOException e) {
            throw new WeiboException(e);
        }
    }

    public void retweet() throws WeiboException {
        this.startHandler(new StreamHandlingThread(new Object[0]){

            public StatusStream getStream() throws WeiboException {
                return WeiboStream.this.getRetweetStream();
            }
        });
    }

    public StatusStream getRetweetStream() throws WeiboException {
        try {
            return new StatusStream(this.http.post(String.valueOf(this.getStreamBaseURL()) + "1/statuses/retweet.json", new PostParameter[0], true));
        }
        catch (IOException e) {
            throw new WeiboException(e);
        }
    }

    public void sample() throws WeiboException {
        this.startHandler(new StreamHandlingThread(null){

            public StatusStream getStream() throws WeiboException {
                return WeiboStream.this.getSampleStream();
            }
        });
    }

    public StatusStream getSampleStream() throws WeiboException {
        try {
            return new StatusStream(this.http.get(String.valueOf(this.getStreamBaseURL()) + "1/statuses/sample.json", true));
        }
        catch (IOException e) {
            throw new WeiboException(e);
        }
    }

    public void filter(int count, int[] follow, String[] track) throws WeiboException {
        this.startHandler(new StreamHandlingThread(new Object[]{count, follow, track}){

            public StatusStream getStream() throws WeiboException {
                return WeiboStream.this.getFilterStream((Integer)this.args[0], (int[])this.args[1], (String[])this.args[2]);
            }
        });
    }

    public StatusStream getFilterStream(int count, int[] follow, String[] track) throws WeiboException {
        ArrayList<PostParameter> postparams = new ArrayList<PostParameter>();
        postparams.add(new PostParameter("count", count));
        if (follow != null && follow.length > 0) {
            postparams.add(new PostParameter("follow", this.toFollowString(follow)));
        }
        if (track != null && track.length > 0) {
            postparams.add(new PostParameter("track", this.toTrackString(track)));
        }
        try {
            return new StatusStream(this.http.post(String.valueOf(this.getStreamBaseURL()) + "1/statuses/filter.json", postparams.toArray(new PostParameter[0]), true));
        }
        catch (IOException e) {
            throw new WeiboException(e);
        }
    }

    public void gardenhose() throws WeiboException {
        this.startHandler(new StreamHandlingThread(null){

            public StatusStream getStream() throws WeiboException {
                return WeiboStream.this.getGardenhoseStream();
            }
        });
    }

    public StatusStream getGardenhoseStream() throws WeiboException {
        return this.getSampleStream();
    }

    public void spritzer() throws WeiboException {
        this.startHandler(new StreamHandlingThread(null){

            public StatusStream getStream() throws WeiboException {
                return WeiboStream.this.getSpritzerStream();
            }
        });
    }

    public StatusStream getSpritzerStream() throws WeiboException {
        return this.getSampleStream();
    }

    public void birddog(int count, int[] follow) throws WeiboException {
        this.startHandler(new StreamHandlingThread(new Object[]{count, follow}){

            public StatusStream getStream() throws WeiboException {
                return WeiboStream.this.getBirddogStream((Integer)this.args[0], (int[])this.args[1]);
            }
        });
    }

    public StatusStream getBirddogStream(int count, int[] follow) throws WeiboException {
        return this.getFilterStream(count, follow, null);
    }

    public void shadow(int count, int[] follow) throws WeiboException {
        this.startHandler(new StreamHandlingThread(new Object[]{count, follow}){

            public StatusStream getStream() throws WeiboException {
                return WeiboStream.this.getShadowStream((Integer)this.args[0], (int[])this.args[1]);
            }
        });
    }

    public StatusStream getShadowStream(int count, int[] follow) throws WeiboException {
        return this.getFilterStream(count, follow, null);
    }

    public void follow(int[] follow) throws WeiboException {
        this.startHandler(new StreamHandlingThread(new Object[]{follow}){

            public StatusStream getStream() throws WeiboException {
                return WeiboStream.this.getFollowStream((int[])this.args[0]);
            }
        });
    }

    public StatusStream getFollowStream(int[] follow) throws WeiboException {
        return this.getFilterStream(0, follow, null);
    }

    private String toFollowString(int[] follows) {
        StringBuffer buf = new StringBuffer(11 * follows.length);
        int[] nArray = follows;
        int n = follows.length;
        int n2 = 0;
        while (n2 < n) {
            int follow = nArray[n2];
            if (buf.length() != 0) {
                buf.append(",");
            }
            buf.append(follow);
            ++n2;
        }
        return buf.toString();
    }

    public void track(final String[] keywords) throws WeiboException {
        this.startHandler(new StreamHandlingThread(null){

            public StatusStream getStream() throws WeiboException {
                return WeiboStream.this.getTrackStream(keywords);
            }
        });
    }

    public StatusStream getTrackStream(String[] keywords) throws WeiboException {
        return this.getFilterStream(0, null, keywords);
    }

    private String toTrackString(String[] keywords) {
        StringBuffer buf = new StringBuffer(20 * keywords.length * 4);
        String[] stringArray = keywords;
        int n = keywords.length;
        int n2 = 0;
        while (n2 < n) {
            String keyword = stringArray[n2];
            if (buf.length() != 0) {
                buf.append(",");
            }
            buf.append(keyword);
            ++n2;
        }
        return buf.toString();
    }

    private synchronized void startHandler(StreamHandlingThread handler) throws WeiboException {
        this.cleanup();
        if (this.statusListener == null) {
            throw new IllegalStateException("StatusListener is not set.");
        }
        this.handler = handler;
        this.handler.start();
    }

    public synchronized void cleanup() {
        if (this.handler != null) {
            try {
                this.handler.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public StatusListener getStatusListener() {
        return this.statusListener;
    }

    public void setStatusListener(StatusListener statusListener) {
        this.statusListener = statusListener;
    }

    private String getStreamBaseURL() {
        return this.USE_SSL ? "https://stream.t.sina.com.cn/" : "http://stream.t.sina.com.cn/";
    }

    private void log(String message) {
        if (DEBUG) {
            System.out.println("[" + new Date() + "]" + message);
        }
    }

    private void log(String message, String message2) {
        if (DEBUG) {
            this.log(String.valueOf(message) + message2);
        }
    }

    abstract class StreamHandlingThread
    extends Thread {
        StatusStream stream;
        Object[] args;
        private List<Long> retryHistory;
        private static final String NAME = "Weibo Stream Handling Thread";
        private boolean closed;

        StreamHandlingThread(Object[] args) {
            super("Weibo Stream Handling Thread[initializing]");
            this.stream = null;
            this.closed = false;
            this.args = args;
            this.retryHistory = new ArrayList<Long>(WeiboStream.this.retryPerMinutes);
        }

        public void run() {
            while (!this.closed) {
                try {
                    Status status;
                    if (this.retryHistory.size() > 0 && System.currentTimeMillis() - this.retryHistory.get(0) > 60000L) {
                        this.retryHistory.remove(0);
                    }
                    if (this.retryHistory.size() < WeiboStream.this.retryPerMinutes) {
                        this.setStatus("[establishing connection]");
                        while (!this.closed && this.stream == null) {
                            if (this.retryHistory.size() >= WeiboStream.this.retryPerMinutes) continue;
                            this.retryHistory.add(System.currentTimeMillis());
                            this.stream = this.getStream();
                        }
                    } else {
                        long timeToSleep = 60000L - (System.currentTimeMillis() - this.retryHistory.get(this.retryHistory.size() - 1));
                        this.setStatus("[retry limit reached. sleeping for " + timeToSleep / 1000L + " secs]");
                        try {
                            Thread.sleep(timeToSleep);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                    if (this.stream == null) continue;
                    this.setStatus("[receiving stream]");
                    while (!this.closed && (status = this.stream.next()) != null) {
                        WeiboStream.this.log("received:", status.toString());
                        if (WeiboStream.this.statusListener == null) continue;
                        WeiboStream.this.statusListener.onStatus(status);
                    }
                }
                catch (WeiboException te) {
                    this.stream = null;
                    te.printStackTrace();
                    WeiboStream.this.log(te.getMessage());
                    WeiboStream.this.statusListener.onException(te);
                }
            }
        }

        public synchronized void close() throws IOException {
            this.setStatus("[disposing thread]");
            if (this.stream != null) {
                this.stream.close();
                this.closed = true;
            }
        }

        private void setStatus(String message) {
            String actualMessage = NAME + message;
            this.setName(actualMessage);
            WeiboStream.this.log(actualMessage);
        }

        abstract StatusStream getStream() throws WeiboException;
    }
}

