/*
 * Decompiled with CFR 0.152.
 */
package com.kingbase8.core.v3;

import com.kingbase8.copy.CopyOperation;
import com.kingbase8.core.v3.QueryExecutorImpl;
import com.kingbase8.util.GT;
import com.kingbase8.util.KSQLException;
import com.kingbase8.util.KSQLState;
import java.sql.SQLException;

public abstract class CopyOperationImpl
implements CopyOperation {
    QueryExecutorImpl queryExecutor;
    int rowFormat;
    int[] fieldFormats;
    long handledRowCount = -1L;

    void init(QueryExecutorImpl q, int fmt, int[] fmts) {
        this.queryExecutor = q;
        this.rowFormat = fmt;
        this.fieldFormats = fmts;
    }

    @Override
    public void cancelCopy() throws SQLException {
        this.queryExecutor.cancelCopy(this);
    }

    @Override
    public int getFieldCount() {
        return this.fieldFormats.length;
    }

    @Override
    public int getFieldFormat(int field) {
        return this.fieldFormats[field];
    }

    @Override
    public int getFormat() {
        return this.rowFormat;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isActive() {
        QueryExecutorImpl queryExecutorImpl = this.queryExecutor;
        synchronized (queryExecutorImpl) {
            return this.queryExecutor.hasLock(this);
        }
    }

    public void handleCommandStatus(String status) throws KSQLException {
        if (!status.startsWith("COPY")) {
            throw new KSQLException(GT.tr("CommandComplete expected COPY but got: " + status, new Object[0]), KSQLState.COMMUNICATION_ERROR);
        }
        int i = status.lastIndexOf(32);
        this.handledRowCount = i > 3 ? Long.parseLong(status.substring(i + 1)) : -1L;
    }

    protected abstract void handleCopydata(byte[] var1) throws KSQLException;

    @Override
    public long getHandledRowCount() {
        return this.handledRowCount;
    }
}

