/*
 * Decompiled with CFR 0.152.
 */
package com.kingbase8.ssl;

import com.kingbase8.KBProperty;
import com.kingbase8.core.KBStream;
import com.kingbase8.core.SocketFactoryFactory;
import com.kingbase8.jdbc.SslMode;
import com.kingbase8.ssl.KBjdbcHostnameVerifier;
import com.kingbase8.ssl.LibPQFactory;
import com.kingbase8.util.GT;
import com.kingbase8.util.KSQLException;
import com.kingbase8.util.KSQLState;
import com.kingbase8.util.LOGGER;
import com.kingbase8.util.ObjectFactory;
import java.io.IOException;
import java.util.Properties;
import java.util.logging.Level;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;

public class MakeSSL
extends ObjectFactory {
    public static void convert(KBStream stream, Properties info) throws KSQLException, IOException {
        SslMode sslMode;
        SSLSocket newConnection;
        LOGGER.log(Level.FINE, "converting regular socket connection to ssl", new Object[0]);
        SSLSocketFactory factory = SocketFactoryFactory.getSslSocketFactory(info);
        try {
            newConnection = (SSLSocket)factory.createSocket(stream.getSocket(), stream.getHostSpec().getHost(), stream.getHostSpec().getPort(), true);
            newConnection.setUseClientMode(true);
            newConnection.startHandshake();
        }
        catch (IOException ex) {
            throw new KSQLException(GT.tr("SSL error: {0}", ex.getMessage()), KSQLState.CONNECTION_FAILURE, (Throwable)ex);
        }
        if (factory instanceof LibPQFactory) {
            ((LibPQFactory)factory).throwKeyManagerException();
        }
        if ((sslMode = SslMode.of(info)).verifyPeerName()) {
            MakeSSL.verifyPeerName(stream, info, newConnection);
        }
        stream.changeSocket(newConnection);
    }

    private static void verifyPeerName(KBStream stream, Properties info, SSLSocket newConnection) throws KSQLException {
        HostnameVerifier hvn;
        String sslhostnameverifier = KBProperty.SSL_HOSTNAME_VERIFIER.get(info);
        if (sslhostnameverifier == null) {
            hvn = KBjdbcHostnameVerifier.INSTANCE;
            sslhostnameverifier = "PgjdbcHostnameVerifier";
        } else {
            try {
                hvn = (HostnameVerifier)MakeSSL.instantiate(sslhostnameverifier, info, false, null);
            }
            catch (Exception e) {
                throw new KSQLException(GT.tr("The HostnameVerifier class provided {0} could not be instantiated.", sslhostnameverifier), KSQLState.CONNECTION_FAILURE, (Throwable)e);
            }
        }
        if (hvn.verify(stream.getHostSpec().getHost(), newConnection.getSession())) {
            return;
        }
        throw new KSQLException(GT.tr("The hostname {0} could not be verified by hostnameverifier {1}.", stream.getHostSpec().getHost(), sslhostnameverifier), KSQLState.CONNECTION_FAILURE);
    }
}

