/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.jdbc.shaded.org.apache.http.client.protocol;

import java.io.IOException;
import java.util.Locale;
import org.apache.kylin.jdbc.shaded.org.apache.http.Header;
import org.apache.kylin.jdbc.shaded.org.apache.http.HeaderElement;
import org.apache.kylin.jdbc.shaded.org.apache.http.HttpEntity;
import org.apache.kylin.jdbc.shaded.org.apache.http.HttpException;
import org.apache.kylin.jdbc.shaded.org.apache.http.HttpResponse;
import org.apache.kylin.jdbc.shaded.org.apache.http.HttpResponseInterceptor;
import org.apache.kylin.jdbc.shaded.org.apache.http.annotation.Immutable;
import org.apache.kylin.jdbc.shaded.org.apache.http.client.entity.DeflateDecompressingEntity;
import org.apache.kylin.jdbc.shaded.org.apache.http.client.entity.GzipDecompressingEntity;
import org.apache.kylin.jdbc.shaded.org.apache.http.protocol.HttpContext;

@Immutable
public class ResponseContentEncoding
implements HttpResponseInterceptor {
    public static final String UNCOMPRESSED = "http.client.response.uncompressed";

    public void process(HttpResponse response, HttpContext context) throws HttpException, IOException {
        HeaderElement[] codecs;
        HeaderElement[] arr$;
        int len$;
        int i$;
        Header ceheader;
        HttpEntity entity = response.getEntity();
        if (entity != null && entity.getContentLength() != 0L && (ceheader = entity.getContentEncoding()) != null && (i$ = 0) < (len$ = (arr$ = (codecs = ceheader.getElements())).length)) {
            HeaderElement codec = arr$[i$];
            String codecname = codec.getName().toLowerCase(Locale.US);
            if ("gzip".equals(codecname) || "x-gzip".equals(codecname)) {
                response.setEntity(new GzipDecompressingEntity(response.getEntity()));
                if (context != null) {
                    context.setAttribute(UNCOMPRESSED, true);
                }
                return;
            }
            if ("deflate".equals(codecname)) {
                response.setEntity(new DeflateDecompressingEntity(response.getEntity()));
                if (context != null) {
                    context.setAttribute(UNCOMPRESSED, true);
                }
                return;
            }
            if ("identity".equals(codecname)) {
                return;
            }
            throw new HttpException("Unsupported Content-Coding: " + codec.getName());
        }
    }
}

