/*
 * Decompiled with CFR 0.152.
 */
package com.sap.db.jdbc;

import com.sap.db.annotations.NotThreadSafe;
import com.sap.db.jdbc.ConnectionProperty;
import com.sap.db.jdbc.ConnectionSapDB;
import com.sap.db.jdbc.SavepointSapDB;
import com.sap.db.jdbc.Session;
import com.sap.db.jdbc.SessionPool;
import com.sap.db.jdbc.packet.EngineFeatures;
import com.sap.db.jdbc.packet.FunctionCode;
import com.sap.db.jdbc.packet.HRequestPacket;
import com.sap.db.jdbc.packet.TransactionState;
import com.sap.db.jdbc.trace.Tracer;
import com.sap.db.util.HexUtils;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;

@NotThreadSafe
public class Transaction {
    private final ConnectionSapDB _connection;
    private final Tracer _tracer;
    private final SessionPool _sessionPool;
    private final String _primaryConnectionPreference;
    private final Map<String, SavepointSapDB> _savepointMap;
    private boolean _autoCommit;
    private boolean _ddlAutoCommit;
    private TransactionState _transactionState;
    private int _numberOfSessionsInvolved;
    private byte[] _transactionID;
    private static int _implicitXAStartCount;
    private static int _implicitXAJoinCount;
    private static int _explicitXAStartCount;
    private static int _explicitXAJoinCount;

    Transaction(ConnectionSapDB connection) {
        this._connection = connection;
        this._tracer = connection.getTracer();
        this._sessionPool = connection.getSessionPool();
        this._primaryConnectionPreference = connection.getConnectionProperty(ConnectionProperty.PRIMARY_CONNECTION);
        this._savepointMap = new HashMap<String, SavepointSapDB>();
        this._autoCommit = true;
        this._ddlAutoCommit = true;
        this._transactionState = TransactionState.None;
    }

    boolean getAutoCommit() {
        return this._autoCommit;
    }

    void setAutoCommit(boolean autoCommit) {
        if (!this._autoCommit && autoCommit && !this._ddlAutoCommit) {
            this._ddlAutoCommit = true;
        }
        this._autoCommit = autoCommit;
    }

    boolean getDDLAutoCommit() {
        return this._ddlAutoCommit;
    }

    void setDDLAutoCommit(boolean ddlAutoCommit) {
        this._ddlAutoCommit = ddlAutoCommit;
    }

    TransactionState getTransactionState() {
        return this._transactionState;
    }

    boolean isWriteTransaction() {
        return this._transactionState == TransactionState.WriteTransaction || this._transactionState == TransactionState.DistributedTransaction;
    }

    void setTransactionState(Session session, TransactionState newState) {
        if (this._transactionState == newState) {
            return;
        }
        if (this._transactionState == TransactionState.DistributedTransaction && newState == TransactionState.WriteTransaction) {
            return;
        }
        if (!this._checkSession(session)) {
            return;
        }
        if (this._transactionState == TransactionState.None && (newState == TransactionState.ReadTransaction || newState == TransactionState.WriteTransaction) || this._transactionState == TransactionState.ReadTransaction && newState == TransactionState.WriteTransaction) {
            this._sessionPool.setPrimarySession(session);
        }
        this._transactionState = newState;
        if (this._tracer.on()) {
            this._tracer.printDistribution(this._connection, "Change Tx " + this.getDisplayTransactionID() + " state to " + this._transactionState.name() + " on session " + session.getTraceString(true, false));
        }
    }

    TransactionState getNewTransactionState(Session session, FunctionCode functionCode) {
        TransactionState newState;
        if (!this._checkSession(session)) {
            return null;
        }
        switch (functionCode) {
            case Commit: 
            case Rollback: 
            case Connect: 
            case Disconnect: {
                newState = TransactionState.None;
                break;
            }
            case XAStart: 
            case XAJoin: 
            case Nil: 
            case CloseCursor: 
            case DDL: {
                newState = null;
                break;
            }
            default: {
                newState = TransactionState.ReadTransaction;
            }
        }
        return newState;
    }

    byte[] handleTransaction(Session session, boolean allowChangePrimaryAndXAJoin, boolean allowImplicitXAJoin) throws SQLException {
        if (session.isHintRouted()) {
            return null;
        }
        this.addSessionToTransaction(session);
        if (!allowChangePrimaryAndXAJoin) {
            return null;
        }
        switch (this._transactionState) {
            case None: {
                this._sessionPool.setPrimarySession(session);
                break;
            }
            case ReadTransaction: {
                break;
            }
            case WriteTransaction: {
                if (this._numberOfSessionsInvolved <= 1) break;
                this._startDistributedTransaction();
                return this._joinDistributedTransaction(session, allowImplicitXAJoin);
            }
            case DistributedTransaction: {
                if (session.isPartOfDistributedTransaction()) break;
                return this._joinDistributedTransaction(session, allowImplicitXAJoin);
            }
        }
        return null;
    }

    void addSessionToTransaction(Session session) {
        if (session.isPartOfTransaction()) {
            return;
        }
        session.joinTransaction();
        ++this._numberOfSessionsInvolved;
    }

    SavepointSapDB getSavepoint(String name) {
        return this._savepointMap.get(name);
    }

    void setSavepoint(SavepointSapDB savepoint) {
        this._savepointMap.put(savepoint._getName(), savepoint);
    }

    void clearTransaction(boolean forCloseOrReconnect) {
        this._savepointMap.clear();
        if (this._transactionState == TransactionState.None && this._numberOfSessionsInvolved == 0 && this._transactionID == null) {
            return;
        }
        this._transactionState = TransactionState.None;
        for (Session session : this._sessionPool.getSessions().values()) {
            session.leaveTransaction();
        }
        if (this._tracer.on() && this._transactionState != TransactionState.Unknown) {
            this._tracer.printDistributionState(this._connection, "Close Tx " + this.getDisplayTransactionID());
        }
        this._numberOfSessionsInvolved = 0;
        this._transactionID = null;
        if (!forCloseOrReconnect && !this._primaryConnectionPreference.equalsIgnoreCase("LASTPRIMARY")) {
            Session lastExecutedSession;
            if (this._primaryConnectionPreference.equalsIgnoreCase("LASTEXECUTE") && (lastExecutedSession = this._sessionPool.getLastPreparedExecuteSessionForNoneOrPrimarySite()) != null) {
                this._sessionPool.setPrimarySession(lastExecutedSession);
            } else {
                Session anchorSession = this._sessionPool.getAnchorSession();
                if (anchorSession != null) {
                    this._sessionPool.setPrimarySession(anchorSession);
                }
            }
        }
    }

    String getDisplayTransactionID() {
        return "[" + HexUtils.toHexString(this._transactionID) + "]";
    }

    byte[] getTransactionID() {
        return this._transactionID;
    }

    void setTransactionID(byte[] transactionID) throws SQLException {
        this._transactionID = transactionID;
    }

    private boolean _checkSession(Session session) {
        Session anchorSession = this._sessionPool.getAnchorSession();
        return anchorSession == null || !anchorSession.isNoneOrPrimarySite() || !session.isSecondarySite();
    }

    private void _startDistributedTransaction() throws SQLException {
        boolean isImplicit;
        if (this._transactionState == TransactionState.DistributedTransaction) {
            return;
        }
        Session session = this._sessionPool.getPrimarySession();
        boolean bl = isImplicit = this._transactionID != null && this._connection.getEngineFeatures().isImplicitXASessionSupported();
        if (isImplicit) {
            ++_implicitXAStartCount;
        } else {
            ++_explicitXAStartCount;
            HRequestPacket requestPacket = this._connection.initStartDistributedTransaction(session);
            this._connection.exchange(session, requestPacket, null, new ConnectionSapDB.ExchangeFlag[0]);
        }
        this._transactionState = TransactionState.DistributedTransaction;
        session.joinDistributedTransaction();
        if (this._tracer.on()) {
            this._tracer.printDistribution(this._connection, (isImplicit ? "Implicit " : "") + "Start Distributed Tx " + this.getDisplayTransactionID() + " on session " + session.getTraceString(true, false));
        }
    }

    private byte[] _joinDistributedTransaction(Session session, boolean allowImplicitXAJoin) throws SQLException {
        byte[] ret;
        EngineFeatures engineFeatures;
        boolean isImplicit;
        if (session.isPartOfDistributedTransaction()) {
            return null;
        }
        boolean bl = isImplicit = allowImplicitXAJoin && (engineFeatures = this._connection.getEngineFeatures()).isImplicitXASessionSupported() && (this._ddlAutoCommit || engineFeatures.supportImplicitXAJoinOnPrepare());
        if (isImplicit) {
            ++_implicitXAJoinCount;
            ret = this._transactionID;
        } else {
            ++_explicitXAJoinCount;
            HRequestPacket requestPacket = this._connection.initJoinDistributedTransaction(session, this._transactionID);
            this._connection.exchange(session, requestPacket, null, new ConnectionSapDB.ExchangeFlag[0]);
            ret = null;
        }
        session.joinDistributedTransaction();
        if (this._tracer.on()) {
            this._tracer.printDistribution(this._connection, (isImplicit ? "Implicit " : "") + "Join Distributed Tx " + this.getDisplayTransactionID() + " on session " + session.getTraceString(true, false));
        }
        return ret;
    }

    static int getImplicitXAStartCount() {
        return _implicitXAStartCount;
    }

    static int getImplicitXAJoinCount() {
        return _implicitXAJoinCount;
    }

    static int getExplicitXAStartCount() {
        return _explicitXAStartCount;
    }

    static int getExplicitXAJoinCount() {
        return _explicitXAJoinCount;
    }

    static void resetCounts() {
        _implicitXAStartCount = 0;
        _implicitXAJoinCount = 0;
        _explicitXAStartCount = 0;
        _explicitXAJoinCount = 0;
    }

    int getSavepointCount() {
        return this._savepointMap.size();
    }
}

