/*
 * Decompiled with CFR 0.152.
 */
package com.sap.db.jdbcext;

import com.sap.db.annotations.ThreadSafe;
import com.sap.db.jdbc.ConnectionProperty;
import com.sap.db.jdbc.ConnectionSapDB;
import java.sql.Connection;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;

@ThreadSafe
public abstract class XAResourceSAP
implements XAResource {
    private final ConnectionSapDB _connection;
    private final String _dburl;

    protected XAResourceSAP(Connection connection) {
        this._connection = ConnectionSapDB.getConnectionSapDB(connection);
        this._dburl = this._connection.getConnectionProperty(ConnectionProperty.DBURL);
    }

    @Override
    public void start(Xid xid, int flags) throws XAException {
        this._connection.start(xid, flags);
    }

    @Override
    public void end(Xid xid, int flags) throws XAException {
        this._connection.end(xid, flags);
    }

    @Override
    public int prepare(Xid xid) throws XAException {
        return this._connection.prepare(xid);
    }

    @Override
    public void commit(Xid xid, boolean onePhase) throws XAException {
        this._connection.commit(xid, onePhase);
    }

    @Override
    public void rollback(Xid xid) throws XAException {
        this._connection.rollback(xid);
    }

    @Override
    public Xid[] recover(int flag) throws XAException {
        return this._connection.recover(flag);
    }

    @Override
    public void forget(Xid xid) throws XAException {
        this._connection.forget(xid);
    }

    @Override
    public int getTransactionTimeout() throws XAException {
        return 0;
    }

    @Override
    public boolean setTransactionTimeout(int seconds) throws XAException {
        return false;
    }

    @Override
    public boolean isSameRM(XAResource object) throws XAException {
        if (object == this) {
            return true;
        }
        if (!(object instanceof XAResourceSAP)) {
            return false;
        }
        XAResourceSAP other = (XAResourceSAP)object;
        return this._dburl.equals(other._dburl);
    }
}

