/*
 * Decompiled with CFR 0.152.
 */
package com.sap.db.util;

import com.sap.db.annotations.Immutable;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

@Immutable
public final class MessageTranslator {
    private static final boolean ENABLE_FORBIDDEN_ERROR_CODE_CHECK = false;
    private static final String MESSAGES = "com.sap.db.jdbc.messages";
    private static final String MESSAGES_ID_POSTFIX = ".id";
    private static final String SQLSTATE_POSTFIX = ".sqlstate";
    private static final int DEFAULT_MESSAGE_ID = -10899;
    private static final String DEFAULT_SQL_STATE = "";
    private static final ResourceBundle BUNDLE;

    private MessageTranslator() {
        throw new AssertionError((Object)"Non-instantiable class");
    }

    public static ResourceBundle getMessages() {
        return BUNDLE;
    }

    public static String translate(String key, Object ... args) {
        if (BUNDLE == null) {
            return MessageTranslator._getNoBundleMessage(key, args);
        }
        try {
            return MessageFormat.format(BUNDLE.getString(key), args);
        }
        catch (MissingResourceException e) {
            return MessageTranslator._getNoBundleMessage(key, args);
        }
    }

    public static int getMessageID(String key) {
        if (BUNDLE == null) {
            return -10899;
        }
        try {
            return Integer.parseInt(BUNDLE.getString(key + MESSAGES_ID_POSTFIX));
        }
        catch (NumberFormatException | MissingResourceException e) {
            return -10899;
        }
    }

    public static String getSQLState(String key) {
        if (BUNDLE == null) {
            return DEFAULT_SQL_STATE;
        }
        try {
            return BUNDLE.getString(key + SQLSTATE_POSTFIX);
        }
        catch (MissingResourceException e) {
            return DEFAULT_SQL_STATE;
        }
    }

    private static String _getNoBundleMessage(String key, Object ... args) {
        StringBuilder builder = new StringBuilder(128);
        builder.append("No message available for locale ");
        builder.append(Locale.getDefault().toString());
        builder.append(", key ");
        builder.append(key);
        if (args == null || args.length == 0) {
            builder.append(".");
        } else {
            builder.append(", arguments [");
            for (Object arg : args) {
                builder.append(arg);
                builder.append(", ");
            }
            builder.setLength(builder.length() - 2);
            builder.append("].");
        }
        return builder.toString();
    }

    static {
        ResourceBundle bundle;
        try {
            bundle = ResourceBundle.getBundle(MESSAGES);
        }
        catch (MissingResourceException e) {
            bundle = null;
        }
        BUNDLE = bundle;
    }
}

