/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.jdbc.utils;

import com.aliyun.odps.utils.StringUtils;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.IOException;
import java.util.Map;
import java.util.Properties;

public class Utils {
    public static final String JDBC_USER_AGENT = "odps.idata.useragent";
    public static final String JDBCKey = "driver.version";
    public static final String SDKKey = "sdk.version";
    public static String JDBCVersion = "JDBC-Version:" + Utils.retrieveVersion("driver.version");
    public static String SDKVersion = "SDK-Version:" + Utils.retrieveVersion("sdk.version");

    public static String retrieveVersion(String key) {
        Properties prop = new Properties();
        try {
            prop.load(Utils.class.getResourceAsStream("/version.properties"));
            return prop.getProperty(key);
        }
        catch (IOException e) {
            return "unknown";
        }
    }

    public static boolean matchPattern(String s, String pattern) {
        if (StringUtils.isNullOrEmpty((String)pattern)) {
            return true;
        }
        pattern = pattern.toLowerCase();
        s = s.toLowerCase();
        if (pattern.contains("%") || pattern.contains("_")) {
            String wildcard = pattern.replaceAll("(?<!\\\\)%", "\\\\w*").replaceAll("(?<!\\\\)_", "\\\\w");
            if (!s.matches(wildcard = wildcard.replace("\\%", "%").replace("\\_", "_"))) {
                return false;
            }
        } else if (!s.equals(pattern)) {
            return false;
        }
        return true;
    }

    public static int getSinkCountFromTaskSummary(String jsonSummary) {
        if (StringUtils.isNullOrEmpty((String)jsonSummary)) {
            return -1;
        }
        int ret = 0;
        try {
            JsonObject summary = new JsonParser().parse(jsonSummary).getAsJsonObject();
            JsonObject outputs = summary.getAsJsonObject("Outputs");
            if ("{}".equals(outputs.toString())) {
                return -1;
            }
            for (Map.Entry entry : outputs.entrySet()) {
                ret += ((JsonElement)entry.getValue()).getAsJsonArray().get(0).getAsInt();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return ret;
    }

    public static String parseSetting(String sql, Properties properties) {
        String s;
        if (StringUtils.isNullOrEmpty((String)sql)) {
            throw new IllegalArgumentException("Invalid query :" + sql);
        }
        if (!(sql = sql.trim()).endsWith(";")) {
            sql = sql + ";";
        }
        int index = 0;
        int end = 0;
        while ((end = sql.indexOf(59, index)) != -1 && (s = sql.substring(index, end)).toUpperCase().matches("(?i)^(\\s*)(SET)(\\s+)(.*)=(.*);?(\\s*)$")) {
            int i = s.toLowerCase().indexOf("set");
            String pairString = s.substring(i + 3);
            String[] pair = pairString.split("=");
            properties.put(pair[0].trim(), pair[1].trim());
            index = end + 1;
        }
        if (index >= sql.length()) {
            return null;
        }
        return sql.substring(index).trim();
    }
}

