/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.jdbc.utils.transformer.to.jdbc;

import com.aliyun.odps.type.TypeInfo;
import java.io.UnsupportedEncodingException;
import java.sql.SQLException;

public abstract class AbstractToJdbcTransformer {
    static final String INVALID_TRANSFORMATION_ERROR_MSG = "Cannot transform ODPS-SDK Java class %s to %s";
    static final String ENCODING_ERR_MSG = "Error happened during encoding, please check the charset";
    static final String TRANSFORMATION_ERR_MSG = "Error happened when transforming %s into %s";

    public abstract Object transform(Object var1, String var2) throws SQLException;

    public Object transform(Object o, String charset, TypeInfo odpsType) throws SQLException {
        return this.transform(o, charset);
    }

    static String getInvalidTransformationErrorMsg(Class odpsCls, Class jdbcCls) {
        return String.format(INVALID_TRANSFORMATION_ERROR_MSG, odpsCls.getName(), jdbcCls.getName());
    }

    static String getTransformationErrMsg(Object o, Class jdbcCls) {
        return String.format(TRANSFORMATION_ERR_MSG, o.toString(), jdbcCls.getName());
    }

    public static String encodeBytes(byte[] bytes, String charset) throws SQLException {
        if (charset != null) {
            try {
                return new String(bytes, charset);
            }
            catch (UnsupportedEncodingException e) {
                throw new SQLException(ENCODING_ERR_MSG, e);
            }
        }
        return new String(bytes);
    }
}

