/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.jdbc.utils.transformer.to.jdbc;

import com.aliyun.odps.jdbc.utils.transformer.to.jdbc.AbstractToJdbcDateTypeTransformer;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;

public class ToJdbcTimeTransfomer
extends AbstractToJdbcDateTypeTransformer {
    /*
     * Loose catch block
     */
    @Override
    public Object transform(Object o, String charset, Calendar cal, TimeZone timeZone) throws SQLException {
        if (o == null) {
            return null;
        }
        if (Date.class.isInstance(o)) {
            long time = ((Date)o).getTime();
            if (timeZone != null) {
                time += (long)timeZone.getOffset(time);
            }
            return new Time(time);
        }
        if (o instanceof byte[]) {
            try {
                SimpleDateFormat datetimeFormat = (SimpleDateFormat)DATETIME_FORMAT.get();
                SimpleDateFormat timeFormat = (SimpleDateFormat)TIME_FORMAT.get();
                if (cal != null) {
                    datetimeFormat.setCalendar(cal);
                    timeFormat.setCalendar(cal);
                }
                try {
                    Time time = new Time(datetimeFormat.parse(ToJdbcTimeTransfomer.encodeBytes((byte[])o, charset)).getTime());
                    return time;
                }
                catch (ParseException parseException) {
                    Time time = new Time(timeFormat.parse(ToJdbcTimeTransfomer.encodeBytes((byte[])o, charset)).getTime());
                    this.restoreToDefaultCalendar();
                    return time;
                    {
                        catch (ParseException parseException2) {
                            String errorMsg = ToJdbcTimeTransfomer.getTransformationErrMsg(ToJdbcTimeTransfomer.encodeBytes((byte[])o, charset), Time.class);
                            throw new SQLException(errorMsg);
                        }
                    }
                }
            }
            finally {
                this.restoreToDefaultCalendar();
            }
        }
        String errorMsg = ToJdbcTimeTransfomer.getInvalidTransformationErrorMsg(o.getClass(), Timestamp.class);
        throw new SQLException(errorMsg);
    }
}

