/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps;

import com.aliyun.odps.Project;
import com.aliyun.odps.commons.util.OSUtils;
import com.aliyun.odps.commons.util.SvnRevisionUtils;
import com.aliyun.odps.rest.SimpleXmlUtils;
import com.aliyun.odps.simpleframework.xml.Element;
import com.aliyun.odps.simpleframework.xml.ElementList;
import com.aliyun.odps.simpleframework.xml.Order;
import com.aliyun.odps.simpleframework.xml.Root;
import com.aliyun.odps.simpleframework.xml.convert.Convert;
import com.aliyun.odps.simpleframework.xml.convert.Converter;
import com.aliyun.odps.simpleframework.xml.stream.InputNode;
import com.aliyun.odps.simpleframework.xml.stream.OutputNode;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public abstract class Task {
    private static Map<String, String> GLOBAL_SETTINGS = new HashMap<String, String>();
    private static final Map<String, String> SYSTEM_SETTINGS = new HashMap<String, String>();
    @Element(name="Name", required=false)
    @Convert(value=SimpleXmlUtils.EmptyStringConverter.class)
    private String name;
    @Element(name="Comment", required=false)
    @Convert(value=SimpleXmlUtils.EmptyStringConverter.class)
    private String comment;
    @Element(name="Config", required=false)
    @Convert(value=PropertyConverter.class)
    private LinkedHashMap<String, String> properties = new LinkedHashMap();

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public final Map<String, String> getProperties() {
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        map.putAll(this.properties);
        return map;
    }

    public final void setProperties(Map<String, String> properties) {
        this.properties = new LinkedHashMap();
        this.properties.putAll(properties);
    }

    public void setProperty(String name, String value) {
        this.properties.put(name, value);
    }

    public String getCommandText() {
        if (this.getProperties().containsKey("commandText")) {
            return this.getProperties().get("commandText");
        }
        return "";
    }

    static Map<String, String> getGlobalSettings() {
        return new HashMap<String, String>(GLOBAL_SETTINGS);
    }

    static void setGlobalSettings(Map<String, String> globalSettings) {
        GLOBAL_SETTINGS = globalSettings;
    }

    void loadSystemSettings() {
        JsonObject settings;
        if (this.properties.containsKey("settings")) {
            JsonParser parser = new JsonParser();
            settings = parser.parse(this.properties.get("settings")).getAsJsonObject();
        } else {
            settings = new JsonObject();
        }
        for (Map.Entry<String, String> setting : SYSTEM_SETTINGS.entrySet()) {
            settings.addProperty(setting.getKey(), setting.getValue());
        }
        this.properties.put("settings", settings.toString());
    }

    void loadGlobalSettings() {
        JsonObject settings;
        if (this.properties.containsKey("settings")) {
            JsonParser parser = new JsonParser();
            settings = parser.parse(this.properties.get("settings")).getAsJsonObject();
        } else {
            settings = new JsonObject();
        }
        for (Map.Entry<String, String> setting : GLOBAL_SETTINGS.entrySet()) {
            if (settings.has(setting.getKey())) continue;
            settings.addProperty(setting.getKey(), setting.getValue());
        }
        this.properties.put("settings", settings.toString());
    }

    static {
        SYSTEM_SETTINGS.put("odps.idata.userenv", "JavaSDK Revision:" + SvnRevisionUtils.getSvnRevision() + ",Version:" + SvnRevisionUtils.getMavenVersion() + ",JavaVersion:" + SvnRevisionUtils.getJavaVersion() + ",IP:" + OSUtils.getIpAddress() + ",MAC:" + OSUtils.getMacAddress());
    }

    static class PropertyConverter
    implements Converter<LinkedHashMap<String, String>> {
        PropertyConverter() {
        }

        @Override
        public void write(OutputNode outputNode, LinkedHashMap<String, String> properties) throws Exception {
            for (Map.Entry<String, String> entry : properties.entrySet()) {
                String name = entry.getKey();
                String value = entry.getValue();
                SimpleXmlUtils.marshal(new Project.Property(name, value), outputNode);
            }
            outputNode.commit();
        }

        @Override
        public LinkedHashMap<String, String> read(InputNode inputNode) throws Exception {
            LinkedHashMap<String, String> properties = new LinkedHashMap<String, String>();
            Project.Properties props = SimpleXmlUtils.unmarshal(inputNode, Project.Properties.class);
            for (Project.Property entry : props.entries) {
                properties.put(entry.name, entry.value);
            }
            return properties;
        }
    }

    @Root(name="Config", strict=false)
    public static class Properties {
        Set<Property> properties = new LinkedHashSet<Property>();

        @ElementList(entry="Property", inline=true, required=false)
        private List<Property> getPropertyList() {
            return new ArrayList<Property>(this.properties);
        }

        @ElementList(entry="Property", inline=true, required=false)
        private void setPropertyList(List<Property> propertyList) {
            this.properties = new LinkedHashSet<Property>(propertyList);
        }

        public void addProperty(Property property) {
            this.properties.add(property);
        }

        public void removeProperty(Property property) {
            this.properties.remove(property);
        }
    }

    @Root(name="Property", strict=false)
    @Order(elements={"Name", "Value"})
    public static class Property {
        @Element(name="Name")
        @Convert(value=SimpleXmlUtils.EmptyStringConverter.class)
        private String name;
        @Element(name="Value")
        @Convert(value=SimpleXmlUtils.EmptyStringConverter.class)
        private String value;

        Property() {
        }

        public Property(String name, String value) {
            this.setName(name);
            this.setValue(value);
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getValue() {
            return this.value;
        }

        public void setValue(String value) {
            this.value = value;
        }
    }
}

