/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps;

import com.aliyun.odps.LazyLoad;
import com.aliyun.odps.Odps;
import com.aliyun.odps.OdpsException;
import com.aliyun.odps.commons.transport.Response;
import com.aliyun.odps.commons.util.DateUtils;
import com.aliyun.odps.rest.ResourceBuilder;
import com.aliyun.odps.rest.SimpleXmlUtils;
import com.aliyun.odps.simpleframework.xml.Element;
import com.aliyun.odps.simpleframework.xml.Root;
import com.aliyun.odps.simpleframework.xml.convert.Convert;
import java.io.UnsupportedEncodingException;
import java.util.Date;
import java.util.Map;

public class XFlow
extends LazyLoad {
    private Odps odps;
    private XFlowModel model;
    private String project;
    private static final String CHARSET = "UTF-8";

    XFlow(XFlowModel model, String project, Odps odps) {
        this.model = model;
        this.odps = odps;
        this.project = project;
    }

    public String getName() {
        return this.model.name;
    }

    public String getSourceXml() {
        if (this.model.getXmlSource() == null) {
            this.lazyLoad();
        }
        return this.model.getXmlSource();
    }

    public String getOwner() {
        if (this.model.owner == null) {
            this.lazyLoad();
        }
        return this.model.owner;
    }

    public Date getCreatedTime() {
        if (this.model.createdTime == null) {
            this.lazyLoad();
        }
        return this.model.createdTime;
    }

    public Date getLastModifiedTime() {
        if (this.model.lastModifiedTime == null) {
            this.lazyLoad();
        }
        return this.model.lastModifiedTime;
    }

    @Override
    public void reload() throws OdpsException {
        String resource = ResourceBuilder.buildXFlowResource(this.project, this.getName());
        Response response = this.odps.getRestClient().request(resource, "GET", null, null, null);
        try {
            this.model.setXmlSource(new String(response.getBody(), CHARSET));
        }
        catch (UnsupportedEncodingException e) {
            throw new OdpsException(e.getMessage(), e);
        }
        Map<String, String> headers = response.getHeaders();
        this.model.owner = headers.get("x-odps-owner");
        try {
            this.model.createdTime = DateUtils.parseRfc822Date(headers.get("x-odps-creation-time"));
            this.model.lastModifiedTime = DateUtils.parseRfc822Date(headers.get("Last-Modified"));
        }
        catch (Exception e) {
            throw new OdpsException("Invalid date format", e);
        }
    }

    @Root(name="xflow", strict=false)
    public static class XFlowModel {
        @Element(name="Name", required=false)
        @Convert(value=SimpleXmlUtils.EmptyStringConverter.class)
        String name;
        @Element(name="Owner", required=false)
        @Convert(value=SimpleXmlUtils.EmptyStringConverter.class)
        String owner;
        @Element(name="CreationTime", required=false)
        @Convert(value=SimpleXmlUtils.DateConverter.class)
        Date createdTime;
        @Element(name="LastModifiedTime", required=false)
        @Convert(value=SimpleXmlUtils.DateConverter.class)
        Date lastModifiedTime;
        private String xmlSource;

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getXmlSource() {
            return this.xmlSource;
        }

        public void setXmlSource(String xmlSource) {
            this.xmlSource = xmlSource;
        }
    }
}

