/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.simpleframework.xml.convert;

import com.aliyun.odps.simpleframework.xml.convert.Convert;
import com.aliyun.odps.simpleframework.xml.convert.ConvertException;
import com.aliyun.odps.simpleframework.xml.convert.Converter;
import com.aliyun.odps.simpleframework.xml.util.Cache;
import com.aliyun.odps.simpleframework.xml.util.ConcurrentCache;
import java.lang.reflect.Constructor;

class ConverterFactory {
    private final Cache<Converter> cache = new ConcurrentCache<Converter>();

    public Converter getInstance(Class type) throws Exception {
        Converter converter = this.cache.fetch(type);
        if (converter == null) {
            return this.getConverter(type);
        }
        return converter;
    }

    public Converter getInstance(Convert convert) throws Exception {
        Class<? extends Converter> type = convert.value();
        if (type.isInterface()) {
            throw new ConvertException("Can not instantiate %s", type);
        }
        return this.getInstance(type);
    }

    private Converter getConverter(Class type) throws Exception {
        Constructor factory = this.getConstructor(type);
        if (factory == null) {
            throw new ConvertException("No default constructor for %s", type);
        }
        return this.getConverter(type, factory);
    }

    private Converter getConverter(Class type, Constructor factory) throws Exception {
        Converter converter = (Converter)factory.newInstance(new Object[0]);
        if (converter != null) {
            this.cache.cache(type, converter);
        }
        return converter;
    }

    private Constructor getConstructor(Class type) throws Exception {
        Constructor factory = type.getDeclaredConstructor(new Class[0]);
        if (!factory.isAccessible()) {
            factory.setAccessible(true);
        }
        return factory;
    }
}

