/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.task;

import com.aliyun.odps.Instance;
import com.aliyun.odps.Odps;
import com.aliyun.odps.OdpsException;
import com.aliyun.odps.Survey;
import com.aliyun.odps.Task;
import com.aliyun.odps.commons.util.EmptyIterator;
import com.aliyun.odps.data.Record;
import com.aliyun.odps.data.ResultSet;
import com.aliyun.odps.rest.SimpleXmlUtils;
import com.aliyun.odps.simpleframework.xml.Element;
import com.aliyun.odps.simpleframework.xml.Root;
import com.aliyun.odps.simpleframework.xml.convert.Convert;
import com.aliyun.odps.task.RecordSetIterator;
import com.aliyun.odps.tunnel.InstanceTunnel;
import com.aliyun.odps.tunnel.io.TunnelRecordReader;
import com.aliyun.odps.utils.CSVRecordParser;
import com.aliyun.odps.utils.StringUtils;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

@Root(name="SQL", strict=false)
public class SQLTask
extends Task {
    @Element(name="Query", required=false)
    @Convert(value=SimpleXmlUtils.EmptyStringConverter.class)
    private String query;
    private static Map<String, String> defaultHints;
    private static final String AnonymousSQLTaskName = "AnonymousSQLTask";

    public String getQuery() {
        return this.query;
    }

    public static void setDefaultHints(Map<String, String> hints) {
        defaultHints = hints;
    }

    public static void removeDefaultHints() {
        defaultHints = null;
    }

    public void setQuery(String query) {
        this.query = query;
    }

    public static List<Record> parseCsvRecord(String csvResult) throws OdpsException {
        return CSVRecordParser.parse(csvResult).getRecords();
    }

    public static List<Record> getResult(Instance instance, String taskName) throws OdpsException {
        Map<String, String> results = instance.getTaskResults();
        String selectResult = results.get(taskName);
        if (selectResult != null) {
            return SQLTask.parseCsvRecord(selectResult);
        }
        return null;
    }

    @Survey
    public static List<Record> getResultByInstanceTunnel(Instance instance, String taskName, Long limit) throws OdpsException, IOException {
        return SQLTask.getResultByInstanceTunnel(instance, taskName, limit, true);
    }

    private static List<Record> getResultByInstanceTunnel(Instance instance, String taskName, Long limit, boolean limitEnabled) throws OdpsException, IOException {
        Record record;
        SQLTask.checkTaskName(instance, taskName);
        InstanceTunnel tunnel = new InstanceTunnel(instance.getOdps());
        InstanceTunnel.DownloadSession session = tunnel.createDownloadSession(instance.getProject(), instance.getId(), limitEnabled);
        long recordCount = session.getRecordCount();
        ArrayList<Record> records = new ArrayList<Record>();
        if (recordCount == 0L) {
            return records;
        }
        if (limit != null && limit < recordCount) {
            recordCount = limit;
        }
        TunnelRecordReader reader = session.openRecordReader(0L, recordCount);
        while ((record = reader.read()) != null) {
            records.add(record);
        }
        return records;
    }

    @Survey
    public static List<Record> getResultByInstanceTunnel(Instance instance, Long limit) throws OdpsException, IOException {
        return SQLTask.getResultByInstanceTunnel(instance, AnonymousSQLTaskName, limit);
    }

    @Survey
    public static List<Record> getResultByInstanceTunnel(Instance instance, String taskName) throws OdpsException, IOException {
        return SQLTask.getResultByInstanceTunnel(instance, taskName, null);
    }

    @Survey
    public static List<Record> getResultByInstanceTunnel(Instance instance) throws OdpsException, IOException {
        return SQLTask.getResultByInstanceTunnel(instance, AnonymousSQLTaskName);
    }

    public static List<Record> getResult(Instance instance) throws OdpsException {
        return SQLTask.getResult(instance, AnonymousSQLTaskName);
    }

    public static ResultSet getResultSet(Instance instance) throws OdpsException, IOException {
        return SQLTask.getResultSet(instance, AnonymousSQLTaskName);
    }

    public static ResultSet getResultSet(Instance instance, String taskName) throws OdpsException, IOException {
        return SQLTask.getResultSet(instance, taskName, null);
    }

    public static ResultSet getResultSet(Instance instance, Long limit) throws OdpsException, IOException {
        return SQLTask.getResultSet(instance, AnonymousSQLTaskName, limit);
    }

    public static ResultSet getResultSet(Instance instance, String taskName, Long limit) throws OdpsException {
        return SQLTask.getResultSet(instance, taskName, limit, false);
    }

    public static ResultSet getResultSet(Instance instance, String taskName, Long limit, boolean limitHint) throws OdpsException {
        return SQLTask.getResultSet(instance, taskName, limit, limitHint, null);
    }

    public static ResultSet getResultSet(Instance instance, String taskName, Long limit, boolean limitHint, URI tunnelEndpoint) throws OdpsException {
        InstanceTunnel.DownloadSession session;
        long recordCount;
        SQLTask.checkTaskName(instance, taskName);
        InstanceTunnel tunnel = new InstanceTunnel(instance.getOdps());
        if (tunnelEndpoint != null) {
            tunnel.setEndpoint(tunnelEndpoint.toString());
        }
        if ((recordCount = (session = tunnel.createDownloadSession(instance.getProject(), instance.getId(), limitHint)).getRecordCount()) == 0L) {
            return new ResultSet(EmptyIterator.emptyIterator(), session.getSchema(), recordCount);
        }
        if (limit != null && limit < recordCount) {
            recordCount = limit;
        }
        return new ResultSet(new RecordSetIterator(session, recordCount), session.getSchema(), recordCount);
    }

    private static void checkTaskName(Instance instance, String taskName) throws OdpsException {
        if (StringUtils.isNullOrEmpty((String)taskName)) {
            throw new OdpsException("Invalid task name.");
        }
        boolean findTask = false;
        for (String n : instance.getTaskNames()) {
            if (!taskName.equals(n)) continue;
            findTask = true;
            break;
        }
        if (!findTask) {
            throw new OdpsException("Invalid task: " + taskName);
        }
    }

    @Override
    public String getCommandText() {
        return this.query;
    }

    public static List<String> getSqlWarning(Instance instance) throws OdpsException {
        return SQLTask.getSqlWarning(instance, AnonymousSQLTaskName);
    }

    public static List<String> getSqlWarning(Instance instance, String taskName) throws OdpsException {
        String warnings = instance.getTaskInfo(taskName, "warnings");
        try {
            LinkedList<String> warningList = new LinkedList<String>();
            JsonObject jsonObject = new JsonParser().parse(warnings).getAsJsonObject();
            if (!jsonObject.has("warnings")) {
                return null;
            }
            JsonArray array = jsonObject.get("warnings").getAsJsonArray();
            for (JsonElement element : array) {
                warningList.add(element.getAsString());
            }
            return warningList;
        }
        catch (JsonParseException e) {
            return null;
        }
    }

    public static Instance run(Odps odps, String sql) throws OdpsException {
        String project = odps.getDefaultProject();
        if (project == null) {
            throw new OdpsException("default project required.");
        }
        return SQLTask.run(odps, project, sql, AnonymousSQLTaskName, null, null, "sql");
    }

    public static Instance run(Odps odps, String project, String sql, Map<String, String> hints, Map<String, String> aliases) throws OdpsException {
        return SQLTask.run(odps, project, sql, AnonymousSQLTaskName, hints, aliases, "sql");
    }

    public static Instance run(Odps odps, String project, String sql, String taskName, Map<String, String> hints, Map<String, String> aliases) throws OdpsException {
        return SQLTask.run(odps, project, sql, taskName, hints, aliases, "sql");
    }

    public static Instance run(Odps odps, String project, String sql, String taskName, Map<String, String> hints, Map<String, String> aliases, int priority) throws OdpsException {
        return SQLTask.run(odps, project, sql, taskName, hints, aliases, priority, "sql");
    }

    private static Instance run(Odps odps, String project, String sql, String taskName, Map<String, String> hints, Map<String, String> aliases, Integer priority, String type) throws OdpsException {
        String json;
        SQLTask task = new SQLTask();
        task.setQuery(sql);
        task.setName(taskName);
        task.setProperty("type", type);
        if (hints == null) {
            hints = defaultHints;
        }
        if (hints != null) {
            try {
                json = new GsonBuilder().disableHtmlEscaping().create().toJson(hints);
                task.setProperty("settings", json);
            }
            catch (Exception e) {
                throw new OdpsException(e.getMessage(), e);
            }
        }
        if (aliases != null) {
            try {
                json = new GsonBuilder().disableHtmlEscaping().create().toJson(aliases);
                task.setProperty("aliases", json);
            }
            catch (Exception e) {
                throw new OdpsException(e.getMessage(), e);
            }
        }
        if (priority != null) {
            return odps.instances().create(project, task, priority);
        }
        return odps.instances().create(project, task);
    }

    static Instance run(Odps odps, String project, String sql, String taskName, Map<String, String> hints, Map<String, String> aliases, String type) throws OdpsException {
        return SQLTask.run(odps, project, sql, taskName, hints, aliases, null, type);
    }
}

