/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.tunnel;

import com.aliyun.odps.OdpsException;
import com.aliyun.odps.commons.util.IOUtils;
import com.aliyun.odps.utils.StringUtils;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;

public class TunnelException
extends OdpsException {
    private String errorMsg;

    public TunnelException() {
    }

    public TunnelException(String requestId, InputStream in, Integer status) {
        String message = "";
        try {
            byte[] bytes = IOUtils.readFully(in);
            message = new String(bytes);
            ByteArrayInputStream bis = new ByteArrayInputStream(bytes);
            this.loadFromJson(bis);
        }
        catch (Exception e) {
            if (StringUtils.isNullOrEmpty((String)message)) {
                message = "Error message not available";
            }
            this.errorMsg = message;
            this.errorCode = "Local Error";
        }
        this.requestId = requestId;
        this.status = status;
    }

    public TunnelException(String message) {
        this(null, message, null);
    }

    public TunnelException(String message, Throwable cause) {
        this(null, message, cause);
    }

    public TunnelException(String requestId, String message) {
        this(requestId, message, null);
    }

    public TunnelException(String requestId, String message, Throwable cause) {
        super(message, cause);
        this.requestId = requestId;
        this.errorCode = "Local Error";
        this.errorMsg = message;
    }

    public TunnelException(InputStream is) {
        this(null, is, null);
    }

    @Override
    public String getMessage() {
        StringBuffer sb = new StringBuffer();
        if (this.requestId != null) {
            sb.append("RequestId=").append(this.requestId);
        }
        if (this.errorCode != null) {
            if (sb.length() > 0) {
                sb.append(", ");
            }
            sb.append("ErrorCode=").append(this.errorCode);
        }
        if (this.errorMsg != null) {
            if (sb.length() > 0) {
                sb.append(", ");
            }
            if (this.requestId != null || this.errorCode != null) {
                sb.append("ErrorMessage=");
            }
            sb.append(this.errorMsg);
        }
        return sb.toString();
    }

    public String getErrorMsg() {
        return this.errorMsg;
    }

    public void setErrorCode(String errorCode) {
        this.errorCode = errorCode;
    }

    public void setErrorMsg(String errorMsg) {
        this.errorMsg = errorMsg;
    }

    @Deprecated
    public void loadFromJson(InputStream is) throws TunnelException, IOException {
        try {
            String json = IOUtils.readStreamAsString(is);
            JsonObject tree = new JsonParser().parse(json).getAsJsonObject();
            String node = null;
            if (tree.has("Code")) {
                this.errorCode = node = tree.get("Code").getAsString();
            }
            if (tree.has("Message")) {
                this.errorMsg = node = tree.get("Message").getAsString();
            }
        }
        catch (Exception e) {
            throw new TunnelException("Parse response failed", e);
        }
        finally {
            if (is != null) {
                is.close();
            }
        }
    }

    @Override
    public String toString() {
        return this.getMessage();
    }
}

