/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.nt;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketException;
import java.nio.channels.SocketChannel;
import javax.net.ssl.HandshakeCompletedListener;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import oracle.jdbc.driver.DMSFactory;
import oracle.jdbc.logging.annotations.DisableTrace;
import oracle.net.nt.MetricsEnabledSSLSocketInputStream;

class MetricsEnabledSSLSocketWrapper
extends SSLSocket {
    DMSFactory.DMSPhase waitEvent;
    MetricsEnabledSSLSocketInputStream meinput;
    SSLSocket socket;

    MetricsEnabledSSLSocketWrapper(Socket socket, DMSFactory.DMSPhase dMSPhase) {
        this.socket = (SSLSocket)socket;
        this.waitEvent = dMSPhase;
    }

    public MetricsEnabledSSLSocketWrapper() {
    }

    public MetricsEnabledSSLSocketWrapper(InetAddress inetAddress, int n2) throws IOException {
        super(inetAddress, n2);
    }

    public MetricsEnabledSSLSocketWrapper(InetAddress inetAddress, int n2, InetAddress inetAddress2, int n3) throws IOException {
        super(inetAddress, n2, inetAddress2, n3);
    }

    public MetricsEnabledSSLSocketWrapper(String string, int n2) throws IOException {
        super(string, n2);
    }

    public MetricsEnabledSSLSocketWrapper(String string, int n2, InetAddress inetAddress, int n3) throws IOException {
        super(string, n2, inetAddress, n3);
    }

    @Override
    public void bind(SocketAddress socketAddress) throws IOException {
        this.socket.bind(socketAddress);
    }

    @Override
    public void close() throws IOException {
        this.socket.close();
    }

    @Override
    public void connect(SocketAddress socketAddress) throws IOException {
        this.socket.connect(socketAddress);
    }

    @Override
    public void connect(SocketAddress socketAddress, int n2) throws IOException {
        this.socket.connect(socketAddress, n2);
    }

    @Override
    public SocketChannel getChannel() {
        return this.socket.getChannel();
    }

    @Override
    public InetAddress getInetAddress() {
        return this.socket.getInetAddress();
    }

    @Override
    public InputStream getInputStream() throws IOException {
        if (this.meinput == null) {
            InputStream inputStream = this.socket.getInputStream();
            this.meinput = new MetricsEnabledSSLSocketInputStream(inputStream, this.waitEvent);
        }
        return this.meinput;
    }

    @Override
    public boolean getKeepAlive() throws SocketException {
        return this.socket.getKeepAlive();
    }

    @Override
    public InetAddress getLocalAddress() {
        return this.socket.getLocalAddress();
    }

    @Override
    public int getLocalPort() {
        return this.socket.getLocalPort();
    }

    @Override
    public SocketAddress getLocalSocketAddress() {
        return this.socket.getLocalSocketAddress();
    }

    @Override
    public boolean getOOBInline() throws SocketException {
        return this.socket.getOOBInline();
    }

    @Override
    public OutputStream getOutputStream() throws IOException {
        return this.socket.getOutputStream();
    }

    @Override
    public int getPort() {
        return this.socket.getPort();
    }

    @Override
    public int getReceiveBufferSize() throws SocketException {
        return this.socket.getReceiveBufferSize();
    }

    @Override
    public SocketAddress getRemoteSocketAddress() {
        return this.socket.getRemoteSocketAddress();
    }

    @Override
    public boolean getReuseAddress() throws SocketException {
        return this.socket.getReuseAddress();
    }

    @Override
    public int getSendBufferSize() throws SocketException {
        return this.socket.getSendBufferSize();
    }

    @Override
    public int getSoLinger() throws SocketException {
        return this.socket.getSoLinger();
    }

    @Override
    public int getSoTimeout() throws SocketException {
        return this.socket.getSoTimeout();
    }

    @Override
    public boolean getTcpNoDelay() throws SocketException {
        return this.socket.getTcpNoDelay();
    }

    @Override
    public int getTrafficClass() throws SocketException {
        return this.socket.getTrafficClass();
    }

    @Override
    public boolean isBound() {
        return this.socket.isBound();
    }

    @Override
    public boolean isClosed() {
        return this.socket.isClosed();
    }

    @Override
    public boolean isConnected() {
        return this.socket.isConnected();
    }

    @Override
    public boolean isInputShutdown() {
        return this.socket.isInputShutdown();
    }

    @Override
    public boolean isOutputShutdown() {
        return this.socket.isOutputShutdown();
    }

    @Override
    public void sendUrgentData(int n2) throws IOException {
        this.socket.sendUrgentData(n2);
    }

    @Override
    public void setKeepAlive(boolean bl) throws SocketException {
        this.socket.setKeepAlive(bl);
    }

    @Override
    public void setOOBInline(boolean bl) throws SocketException {
        this.socket.setOOBInline(bl);
    }

    @Override
    public void setPerformancePreferences(int n2, int n3, int n4) {
        this.socket.setPerformancePreferences(n2, n3, n4);
    }

    @Override
    public void setReceiveBufferSize(int n2) throws SocketException {
        this.socket.setReceiveBufferSize(n2);
    }

    @Override
    public void setReuseAddress(boolean bl) throws SocketException {
        this.socket.setReuseAddress(bl);
    }

    @Override
    public void setSendBufferSize(int n2) throws SocketException {
        this.socket.setSendBufferSize(n2);
    }

    @Override
    public void setSoLinger(boolean bl, int n2) throws SocketException {
        this.socket.setSoLinger(bl, n2);
    }

    @Override
    public void setSoTimeout(int n2) throws SocketException {
        this.socket.setSoTimeout(n2);
    }

    @Override
    public void setTcpNoDelay(boolean bl) throws SocketException {
        this.socket.setTcpNoDelay(bl);
    }

    @Override
    public void setTrafficClass(int n2) throws SocketException {
        this.socket.setTrafficClass(n2);
    }

    @Override
    public void shutdownInput() throws IOException {
        this.socket.shutdownInput();
    }

    @Override
    public void shutdownOutput() throws IOException {
        this.socket.shutdownOutput();
    }

    @Override
    @DisableTrace
    public String toString() {
        return this.socket.toString();
    }

    @Override
    public void addHandshakeCompletedListener(HandshakeCompletedListener handshakeCompletedListener) {
        this.socket.addHandshakeCompletedListener(handshakeCompletedListener);
    }

    @Override
    public String[] getEnabledCipherSuites() {
        return this.socket.getEnabledCipherSuites();
    }

    @Override
    public String[] getEnabledProtocols() {
        return this.socket.getEnabledProtocols();
    }

    @Override
    public boolean getEnableSessionCreation() {
        return this.socket.getEnableSessionCreation();
    }

    @Override
    public boolean getNeedClientAuth() {
        return this.socket.getNeedClientAuth();
    }

    @Override
    public SSLSession getSession() {
        return this.socket.getSession();
    }

    @Override
    public String[] getSupportedCipherSuites() {
        return this.socket.getSupportedCipherSuites();
    }

    @Override
    public String[] getSupportedProtocols() {
        return this.socket.getSupportedProtocols();
    }

    @Override
    public boolean getUseClientMode() {
        return this.socket.getUseClientMode();
    }

    @Override
    public boolean getWantClientAuth() {
        return this.socket.getWantClientAuth();
    }

    @Override
    public void removeHandshakeCompletedListener(HandshakeCompletedListener handshakeCompletedListener) {
        this.socket.removeHandshakeCompletedListener(handshakeCompletedListener);
    }

    @Override
    public void setEnabledCipherSuites(String[] stringArray) {
        this.socket.setEnabledCipherSuites(stringArray);
    }

    @Override
    public void setEnabledProtocols(String[] stringArray) {
        this.socket.setEnabledProtocols(stringArray);
    }

    @Override
    public void setEnableSessionCreation(boolean bl) {
        this.socket.setEnableSessionCreation(bl);
    }

    @Override
    public void setNeedClientAuth(boolean bl) {
        this.socket.setNeedClientAuth(bl);
    }

    @Override
    public void setUseClientMode(boolean bl) {
        this.socket.setUseClientMode(bl);
    }

    @Override
    public void setWantClientAuth(boolean bl) {
        this.socket.setWantClientAuth(bl);
    }

    @Override
    public void startHandshake() throws IOException {
        this.socket.startHandshake();
    }
}

