/*
 * Decompiled with CFR 0.152.
 */
package org.operamasks.faces.binding.impl;

import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import javax.el.MethodExpression;
import javax.el.MethodInfo;
import javax.el.ValueExpression;
import javax.faces.component.ActionSource2;
import javax.faces.component.UICommand;
import javax.faces.component.UIComponent;
import javax.faces.component.UIData;
import javax.faces.component.UIViewRoot;
import javax.faces.context.FacesContext;
import javax.faces.event.ActionListener;
import javax.faces.event.PhaseId;
import org.operamasks.faces.binding.ModelBean;
import org.operamasks.faces.binding.ModelBindingContext;
import org.operamasks.faces.binding.impl.ActionMethodAdapter;
import org.operamasks.faces.binding.impl.Binding;
import org.operamasks.faces.binding.impl.BindingUtils;
import org.operamasks.faces.binding.impl.CompositeActionListener;
import org.operamasks.faces.binding.impl.CompositeMethodAdapter;
import org.operamasks.faces.binding.impl.DataItemActionListener;
import org.operamasks.faces.binding.impl.DataItemMethodAdapter;
import org.operamasks.faces.binding.impl.MethodActionListener;
import org.operamasks.faces.binding.impl.ModelSecurity;
import org.operamasks.faces.binding.impl.RowDataValueAdapter;
import org.operamasks.faces.binding.impl.ValueWrapper;
import org.operamasks.faces.component.ajax.AjaxAction;
import org.operamasks.faces.internal.util.OMUtils;

public final class ActionBinding
extends Binding {
    private String id;
    private String event;
    private String label;
    private String description;
    private boolean immediate;
    private Method actionMethod;
    private Method actionListenerMethod;
    private Class<?> declaringClass;
    private ModelSecurity security;
    private static final MethodInfo ActionMethodInfo = new MethodInfo("action", Object.class, new Class[0]);

    ActionBinding(String viewId, String id) {
        super(viewId);
        this.id = id;
    }

    public String getId() {
        return this.id;
    }

    public String getEvent() {
        return this.event;
    }

    public void setEvent(String event) {
        this.event = event;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public boolean isImmediate() {
        return this.immediate;
    }

    public void setImmediate(boolean immediate) {
        this.immediate = immediate;
    }

    public Method getActionMethod() {
        return this.actionMethod;
    }

    public void setActionMethod(Method method) {
        method.setAccessible(true);
        this.actionMethod = BindingUtils.getInterfaceMethod((Method)method);
        this.declaringClass = method.getDeclaringClass();
        this.security = ModelSecurity.scan((AnnotatedElement)method);
    }

    public Method getActionListenerMethod() {
        return this.actionListenerMethod;
    }

    public void setActionListenerMethod(Method method) {
        method.setAccessible(true);
        this.actionListenerMethod = BindingUtils.getInterfaceMethod((Method)method);
        this.declaringClass = method.getDeclaringClass();
    }

    public Class getDeclaringClass() {
        return this.declaringClass;
    }

    public void apply(FacesContext ctx, ModelBindingContext mbc) {
        PhaseId phaseId = mbc.getPhaseId();
        ModelBean bean = mbc.getModelBean();
        if ("*".equals(this.id)) {
            UIComponent comp;
            if (this.event == null && this.actionListenerMethod != null && phaseId == PhaseId.RESTORE_VIEW && (comp = mbc.getComponent()) instanceof ActionSource2) {
                this.applyActionListenerMethod(phaseId, (ActionSource2)comp, bean, this.actionListenerMethod);
            }
        } else {
            UIComponent comp = mbc.getComponent(this.id);
            if (comp != null) {
                if (this.event != null) {
                    this.applyEventAction(phaseId, comp, bean, this.event);
                } else {
                    boolean disabled = false;
                    if (this.security != null && comp.getValueExpression("disabled") == null) {
                        disabled = !this.security.isUserInRole(ctx);
                        comp.setValueExpression("disabled", (ValueExpression)new ValueWrapper((Object)disabled, Boolean.TYPE));
                    }
                    if (!disabled && comp instanceof ActionSource2 && phaseId == PhaseId.RESTORE_VIEW) {
                        this.applyAction(phaseId, (ActionSource2)comp, bean);
                    }
                    if (comp instanceof UICommand && phaseId == PhaseId.RENDER_RESPONSE) {
                        if (!disabled) {
                            this.applyAction(phaseId, (ActionSource2)comp, bean);
                        }
                        this.setText(comp, bean, this.label, "label", "value");
                        this.setText(comp, bean, this.description, "description", "title");
                    }
                }
            }
        }
    }

    public void applyDataItem(FacesContext ctx, ModelBindingContext mbc, UIData data) {
        PhaseId phaseId = mbc.getPhaseId();
        if ("*".equals(this.id)) {
            UIComponent comp;
            if (this.event == null && this.actionListenerMethod != null && phaseId == PhaseId.RESTORE_VIEW && (comp = mbc.getComponent()) instanceof ActionSource2) {
                this.applyDataItemActionListener(phaseId, (ActionSource2)comp, data, this.actionListenerMethod);
            }
        } else {
            UIComponent comp = mbc.getComponent(this.id);
            if (comp != null) {
                if (this.event != null) {
                    this.applyDataItemEventAction(phaseId, comp, data, this.event);
                } else {
                    boolean disabled = false;
                    if (this.security != null && comp.getValueExpression("disabled") == null) {
                        disabled = !this.security.isUserInRole(ctx);
                        comp.setValueExpression("disabled", (ValueExpression)new ValueWrapper((Object)disabled, Boolean.TYPE));
                    }
                    if (!disabled && comp instanceof ActionSource2 && phaseId == PhaseId.RESTORE_VIEW) {
                        this.applyDataItemAction(phaseId, (ActionSource2)comp, data);
                    }
                    if (comp instanceof UICommand && phaseId == PhaseId.RENDER_RESPONSE) {
                        RowDataValueAdapter rowData = new RowDataValueAdapter(data);
                        this.setText(comp, rowData, this.label, "label", "value");
                        this.setText(comp, rowData, this.description, "description", "title");
                    }
                }
            }
        }
    }

    private void setText(UIComponent comp, Object scope, String text, String messageId, String attribute) {
        if (comp.getValueExpression(attribute) == null) {
            if ((text == null || text.length() == 0) && (text = OMUtils.getLocalString((Class)this.getDeclaringClass(), (String)(String.valueOf(this.id) + "." + messageId))) == null && messageId.equals("label")) {
                text = OMUtils.toCamelCase((String)this.id);
            }
            if (text != null) {
                ValueExpression ve = BindingUtils.createValueWrapper((Object)scope, (String)text, String.class);
                comp.setValueExpression(attribute, ve);
            }
        }
    }

    private void applyEventAction(PhaseId phaseId, UIComponent comp, ModelBean bean, String event) {
        UIViewRoot view;
        String renderKitId;
        String actionId = String.valueOf(comp.getId()) + "-" + event;
        AjaxAction source = null;
        for (UIComponent kid : comp.getChildren()) {
            if (!(kid instanceof AjaxAction) || !actionId.equals(kid.getId())) continue;
            source = (AjaxAction)kid;
            break;
        }
        if (source == null) {
            source = new AjaxAction();
            source.setId(actionId);
            source.setEvent(event);
            source.setTransient(true);
            comp.getChildren().add(source);
            source.attachEvent(event, comp);
        }
        this.applyAction(phaseId, (ActionSource2)source, bean);
        if (phaseId == PhaseId.RENDER_RESPONSE && ((renderKitId = (view = FacesContext.getCurrentInstance().getViewRoot()).getRenderKitId()) == null || "HTML_BASIC".equals(renderKitId))) {
            view.setRenderKitId("AJAX");
        }
    }

    private void applyAction(PhaseId phaseId, ActionSource2 source, ModelBean bean) {
        if (this.actionMethod != null) {
            this.applyActionMethod(phaseId, source, bean, this.actionMethod);
        }
        if (this.actionListenerMethod != null) {
            this.applyActionListenerMethod(phaseId, source, bean, this.actionListenerMethod);
        }
    }

    private void applyActionMethod(PhaseId phaseId, ActionSource2 source, ModelBean bean, Method method) {
        CompositeMethodAdapter adapter;
        MethodExpression previous = source.getActionExpression();
        if (previous != null && !(previous instanceof CompositeMethodAdapter)) {
            return;
        }
        if (previous == null || phaseId != ((CompositeMethodAdapter)previous).getPhaseId()) {
            adapter = new CompositeMethodAdapter(ActionMethodInfo);
            adapter.setPhaseId(phaseId);
            source.setActionExpression((MethodExpression)adapter);
            boolean immediate = this.immediate;
            if (source instanceof UICommand && ((UICommand)source).isImmediateSet()) {
                immediate = ((UICommand)source).isImmediate();
            }
            source.setImmediate(immediate);
        } else {
            adapter = (CompositeMethodAdapter)previous;
        }
        adapter.addMethodBinding((MethodExpression)new ActionMethodAdapter(bean, method));
    }

    private void applyActionListenerMethod(PhaseId phaseId, ActionSource2 source, ModelBean bean, Method method) {
        CompositeActionListener adapter = null;
        ActionListener[] actionListenerArray = source.getActionListeners();
        int n = actionListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            ActionListener l = actionListenerArray[n2];
            if (l instanceof CompositeActionListener) {
                if (phaseId != ((CompositeActionListener)l).getPhaseId()) {
                    source.removeActionListener(l);
                } else {
                    adapter = (CompositeActionListener)l;
                    break;
                }
            }
            ++n2;
        }
        if (adapter == null) {
            adapter = new CompositeActionListener();
            adapter.setPhaseId(phaseId);
            source.addActionListener((ActionListener)adapter);
            source.setImmediate(this.immediate);
        }
        adapter.addActionListener((ActionListener)new MethodActionListener(bean, method));
    }

    private void applyDataItemEventAction(PhaseId phaseId, UIComponent comp, UIData data, String event) {
        UIViewRoot view;
        String renderKitId;
        String actionId = String.valueOf(comp.getId()) + "-" + event;
        AjaxAction source = null;
        for (UIComponent kid : comp.getChildren()) {
            if (!(kid instanceof AjaxAction) || !actionId.equals(kid.getId())) continue;
            source = (AjaxAction)kid;
            break;
        }
        if (source == null) {
            source = new AjaxAction();
            source.setId(actionId);
            source.setEvent(event);
            source.setTransient(true);
            comp.getChildren().add(source);
            source.attachEvent(event, comp);
        }
        this.applyDataItemAction(phaseId, (ActionSource2)source, data);
        if (phaseId == PhaseId.RENDER_RESPONSE && ((renderKitId = (view = FacesContext.getCurrentInstance().getViewRoot()).getRenderKitId()) == null || "HTML_BASIC".equals(renderKitId))) {
            view.setRenderKitId("AJAX");
        }
    }

    private void applyDataItemAction(PhaseId phaseId, ActionSource2 source, UIData data) {
        if (this.actionMethod != null) {
            this.applyDataItemActionMethod(phaseId, source, data, this.actionMethod);
        }
        if (this.actionListenerMethod != null) {
            this.applyDataItemActionListener(phaseId, source, data, this.actionListenerMethod);
        }
    }

    private void applyDataItemActionMethod(PhaseId phaseId, ActionSource2 source, UIData data, Method method) {
        CompositeMethodAdapter adapter;
        MethodExpression previous = source.getActionExpression();
        if (previous != null && !(previous instanceof CompositeMethodAdapter)) {
            return;
        }
        if (previous == null || phaseId != ((CompositeMethodAdapter)previous).getPhaseId()) {
            adapter = new CompositeMethodAdapter(ActionMethodInfo);
            adapter.setPhaseId(phaseId);
            source.setActionExpression((MethodExpression)adapter);
            source.setImmediate(this.immediate);
        } else {
            adapter = (CompositeMethodAdapter)previous;
        }
        adapter.addMethodBinding((MethodExpression)new DataItemMethodAdapter(data, method));
    }

    private void applyDataItemActionListener(PhaseId phaseId, ActionSource2 source, UIData data, Method method) {
        CompositeActionListener adapter = null;
        ActionListener[] actionListenerArray = source.getActionListeners();
        int n = actionListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            ActionListener l = actionListenerArray[n2];
            if (l instanceof CompositeActionListener) {
                if (phaseId != ((CompositeActionListener)l).getPhaseId()) {
                    source.removeActionListener(l);
                } else {
                    adapter = (CompositeActionListener)l;
                    break;
                }
            }
            ++n2;
        }
        if (adapter == null) {
            adapter = new CompositeActionListener();
            adapter.setPhaseId(phaseId);
            source.addActionListener((ActionListener)adapter);
            source.setImmediate(this.immediate);
        }
        adapter.addActionListener((ActionListener)new DataItemActionListener(data, method));
    }
}

