/*
 * Decompiled with CFR 0.152.
 */
package org.operamasks.faces.binding.impl;

import elite.lang.Closure;
import javax.el.MethodExpression;
import javax.el.MethodInfo;
import javax.el.ValueExpression;
import javax.faces.component.ActionSource2;
import javax.faces.component.UICommand;
import javax.faces.component.UIComponent;
import javax.faces.component.UIViewRoot;
import javax.faces.context.FacesContext;
import javax.faces.event.ActionListener;
import javax.faces.event.PhaseId;
import org.operamasks.faces.binding.ModelBindingContext;
import org.operamasks.faces.binding.impl.Binding;
import org.operamasks.faces.binding.impl.BindingUtils;
import org.operamasks.faces.binding.impl.ClosureActionListener;
import org.operamasks.faces.binding.impl.ClosureMethodAdapter;
import org.operamasks.faces.binding.impl.CompositeActionListener;
import org.operamasks.faces.binding.impl.CompositeMethodAdapter;
import org.operamasks.faces.binding.impl.ELiteBean;
import org.operamasks.faces.component.ajax.AjaxAction;
import org.operamasks.faces.internal.util.OMUtils;

public class ELActionBinding
extends Binding {
    private String id;
    private String event;
    private boolean immediate;
    private Closure action;
    private Closure actionListener;
    private static final MethodInfo ActionMethodInfo = new MethodInfo("action", Object.class, new Class[0]);

    public ELActionBinding(String id, String event, boolean immediate) {
        super(null);
        this.id = id;
        this.event = event;
        this.immediate = immediate;
    }

    public String getId() {
        return this.id;
    }

    public String getEvent() {
        return this.event;
    }

    public boolean isImmediate() {
        return this.immediate;
    }

    public Closure getAction() {
        return this.action;
    }

    public void setAction(Closure action) {
        this.action = action;
    }

    public Closure getActionListener() {
        return this.actionListener;
    }

    public void setActionListener(Closure actionListener) {
        this.actionListener = actionListener;
    }

    public void apply(FacesContext ctx, ModelBindingContext mbc) {
        PhaseId phaseId = mbc.getPhaseId();
        if ("*".equals(this.id)) {
            UIComponent comp;
            if (this.event == null && this.actionListener != null && phaseId == PhaseId.RESTORE_VIEW && (comp = mbc.getComponent()) instanceof ActionSource2) {
                this.applyActionListenerClosure(phaseId, (ActionSource2)comp, this.actionListener);
            }
        } else {
            UIComponent comp = mbc.getComponent(this.id);
            if (comp != null) {
                if (this.event != null) {
                    this.applyEventAction(phaseId, comp, this.event);
                } else {
                    if (comp instanceof ActionSource2 && phaseId == PhaseId.RESTORE_VIEW) {
                        this.applyAction(phaseId, (ActionSource2)comp);
                    }
                    if (comp instanceof UICommand && phaseId == PhaseId.RENDER_RESPONSE) {
                        ELiteBean bean = (ELiteBean)mbc.getModelBean();
                        this.setText(comp, bean, "label", "value");
                        this.setText(comp, bean, "description", "title");
                    }
                }
            }
        }
    }

    private void applyEventAction(PhaseId phaseId, UIComponent comp, String event) {
        UIViewRoot view;
        String renderKitId;
        String actionId = comp.getId() + "-" + event;
        AjaxAction source = null;
        for (UIComponent kid : comp.getChildren()) {
            if (!(kid instanceof AjaxAction) || !actionId.equals(kid.getId())) continue;
            source = (AjaxAction)kid;
            break;
        }
        if (source == null) {
            source = new AjaxAction();
            source.setId(actionId);
            source.setEvent(event);
            source.setTransient(true);
            comp.getChildren().add(source);
            source.attachEvent(event, comp);
        }
        this.applyAction(phaseId, (ActionSource2)source);
        if (phaseId == PhaseId.RENDER_RESPONSE && ((renderKitId = (view = FacesContext.getCurrentInstance().getViewRoot()).getRenderKitId()) == null || "HTML_BASIC".equals(renderKitId))) {
            view.setRenderKitId("AJAX");
        }
    }

    private void applyAction(PhaseId phaseId, ActionSource2 source) {
        if (this.action != null) {
            this.applyActionClosure(phaseId, source, this.action);
        }
        if (this.actionListener != null) {
            this.applyActionListenerClosure(phaseId, source, this.actionListener);
        }
    }

    private void applyActionClosure(PhaseId phaseId, ActionSource2 source, Closure closure) {
        CompositeMethodAdapter adapter;
        MethodExpression previous = source.getActionExpression();
        if (previous != null && !(previous instanceof CompositeMethodAdapter)) {
            return;
        }
        if (previous == null || phaseId != ((CompositeMethodAdapter)previous).getPhaseId()) {
            adapter = new CompositeMethodAdapter(ActionMethodInfo);
            adapter.setPhaseId(phaseId);
            source.setActionExpression((MethodExpression)adapter);
            source.setImmediate(this.immediate);
        } else {
            adapter = (CompositeMethodAdapter)previous;
        }
        adapter.addMethodBinding((MethodExpression)new ClosureMethodAdapter(closure));
    }

    private void applyActionListenerClosure(PhaseId phaseId, ActionSource2 source, Closure closure) {
        CompositeActionListener adapter = null;
        for (ActionListener l : source.getActionListeners()) {
            if (!(l instanceof CompositeActionListener)) continue;
            if (phaseId != ((CompositeActionListener)l).getPhaseId()) {
                source.removeActionListener(l);
                continue;
            }
            adapter = (CompositeActionListener)l;
            break;
        }
        if (adapter == null) {
            adapter = new CompositeActionListener();
            adapter.setPhaseId(phaseId);
            source.addActionListener((ActionListener)adapter);
            source.setImmediate(this.immediate);
        }
        adapter.addActionListener((ActionListener)new ClosureActionListener(closure));
    }

    private void setText(UIComponent comp, ELiteBean bean, String key, String attribute) {
        if (comp.getValueExpression(attribute) == null) {
            String text = bean.getLocalString(this.id + "." + key);
            if (text == null && key.equals("label")) {
                text = OMUtils.toCamelCase((String)this.id);
            }
            if (text != null) {
                ValueExpression ve = BindingUtils.createValueWrapper(null, (String)text, String.class);
                comp.setValueExpression(attribute, ve);
            }
        }
    }
}

