/*
 * Decompiled with CFR 0.152.
 */
package org.operamasks.faces.binding.impl.processor.bean;

import java.lang.reflect.Field;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.List;
import javax.faces.FacesException;
import org.operamasks.faces.annotation.DataModel;
import org.operamasks.faces.binding.impl.Binding;
import org.operamasks.faces.binding.impl.DataModelBinding;
import org.operamasks.faces.binding.impl.processor.bean.AnnotationProcessor;
import org.operamasks.resources.Resources;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataModelProcessor
extends AnnotationProcessor<DataModel> {
    public DataModelProcessor() {
        super(DataModel.class);
    }

    protected Binding build(DataModel meta, Class<?> targetClass, Field field) {
        DataModelBinding b = new DataModelBinding(meta.view());
        b.init(DataModel.class, targetClass, field);
        this.initDataModelBinding(b, meta);
        return b;
    }

    protected Binding build(DataModel meta, Class<?> targetClass, Method method) {
        String methodName = method.getName();
        Class<?> returnType = method.getReturnType();
        Class<?>[] paramTypes = method.getParameterTypes();
        DataModelBinding b = new DataModelBinding(meta.view());
        if (methodName.startsWith("get") || methodName.startsWith("set")) {
            b.init(DataModel.class, targetClass, method);
        } else {
            if (paramTypes.length != 0 || returnType == Void.TYPE) {
                throw new FacesException(Resources._T((String)"MVB_INVALID_READ_METHOD", (Object[])new Object[]{methodName}));
            }
            b.init(DataModel.class, methodName, returnType, targetClass, null, method, null);
            b.setDeclaringClass(method.getDeclaringClass());
        }
        this.initDataModelBinding(b, meta);
        return b;
    }

    private void initDataModelBinding(DataModelBinding b, DataModel meta) {
        String id;
        String name = b.getName();
        Class type = b.getType();
        Field field = b.getField();
        Method method = b.getReadMethod();
        if (field == null && method == null) {
            throw new FacesException(name + ": The data model binding must have a get method.");
        }
        Class<?> itemType = meta.itemType();
        if (itemType == null || itemType == Object.class) {
            if (type.isArray()) {
                itemType = type.getComponentType();
            } else if (List.class.isAssignableFrom(type)) {
                Type[] args;
                Type t;
                Type type2 = t = method != null ? method.getGenericReturnType() : field.getGenericType();
                if (t instanceof ParameterizedType && (args = ((ParameterizedType)t).getActualTypeArguments()).length == 1) {
                    if (args[0] instanceof Class) {
                        itemType = (Class<?>)args[0];
                    } else if (args[0] instanceof GenericArrayType) {
                        itemType = args[0].getClass();
                    }
                }
            }
            if (itemType == null || itemType == Object.class) {
                throw new FacesException(name + ": The itemType must be specified.");
            }
        }
        if ((id = meta.id()) == null || id.length() == 0) {
            id = name;
        }
        b.setId(id);
        b.setItemType(itemType);
    }
}

