/*
 * Decompiled with CFR 0.152.
 */
package org.operamasks.faces.component.ajax.base;

import java.util.logging.Level;
import java.util.logging.Logger;
import javax.el.ValueExpression;
import javax.faces.component.UIComponent;
import javax.faces.component.UIComponentBase;
import javax.faces.context.FacesContext;
import org.operamasks.faces.binding.ComponentBinder;
import org.operamasks.faces.binding.ModelBindingContext;
import org.operamasks.faces.developer.util.FacesUtils;
import org.operamasks.faces.internal.stub.component.UpdaterStub;
import org.operamasks.faces.render.ajax.AjaxRenderKitImpl;
import org.operamasks.faces.util.LoggerUtil;

public abstract class AjaxUpdaterBase
extends UIComponentBase
implements ComponentBinder,
UpdaterStub {
    public static final String RENDER_ID_PARAM = "org.operamasks.faces.RenderId";
    public static final String COMPONENT_FAMILY = "org.operamasks.faces.AjaxUpdater";
    private static final Logger logger = LoggerUtil.getLogger((String)"org.operamasks.faces.view");
    protected String jsvar;
    protected String renderId;
    protected String url;
    protected String context;
    private String subviewId;
    protected Boolean update;
    protected String charEncoding;
    protected String layout;
    protected String style;
    protected String styleClass;
    protected Boolean globalAction;
    protected Boolean frame;
    private boolean isNewView;
    private boolean viewRestored;

    public void setSubviewId(String value) {
        this.subviewId = value;
    }

    public String getSubviewId() {
        return this.fixURL(this.subviewId);
    }

    public String getFamily() {
        return COMPONENT_FAMILY;
    }

    public String getRenderId() {
        ValueExpression ve;
        String result = this.renderId;
        if ((result == null || result.length() == 0) && (ve = this.getValueExpression("renderId")) != null) {
            result = (String)ve.getValue(this.getFacesContext().getELContext());
        }
        if (result == null || result.length() == 0) {
            result = this.getClientId(this.getFacesContext());
        }
        return result;
    }

    public abstract void setRenderId(String var1);

    public static final String getRequestRenderId(FacesContext context) {
        String renderId = null;
        if (AjaxRenderKitImpl.isAjaxResponse((FacesContext)context) && (renderId = (String)context.getExternalContext().getRequestParameterMap().get(RENDER_ID_PARAM)) != null && renderId.length() == 0) {
            renderId = null;
        }
        return renderId;
    }

    public abstract String getUrl();

    public void setUrl(String url) {
        if (this.getFrame().booleanValue()) {
            this.subviewId = url;
        }
        this.url = url;
    }

    public Boolean getUpdate() {
        if (this.update != null) {
            return this.update;
        }
        ValueExpression ve = this.getValueExpression("update");
        if (ve != null) {
            return (Boolean)ve.getValue(this.getFacesContext().getELContext());
        }
        return true;
    }

    public abstract void setUpdate(Boolean var1);

    public Boolean getGlobalAction() {
        if (this.globalAction != null) {
            return this.globalAction;
        }
        ValueExpression ve = this.getValueExpression("globalAction");
        if (ve != null) {
            return (Boolean)ve.getValue(this.getFacesContext().getELContext());
        }
        return true;
    }

    public abstract void setGlobalAction(Boolean var1);

    public abstract void setContext(String var1);

    public boolean isNewView() {
        return this.isNewView;
    }

    public void setNewView(boolean newView) {
        this.isNewView = newView;
    }

    public boolean viewRestored() {
        return this.viewRestored;
    }

    public void viewRestored(boolean viewRestored) {
        this.viewRestored = viewRestored;
    }

    public void applyModel(FacesContext ctx, ModelBindingContext mbc) {
        mbc.applyInnerModel(ctx, this.getSubviewId(), (UIComponent)this);
    }

    public void load(String url) {
        this.load(url, null);
    }

    public void load(String url, String context) {
        this.url = url;
        if (Boolean.TRUE.equals(this.frame)) {
            this.setSubviewId(url);
            this.setNewView(true);
            return;
        }
        if ((url = this.fixURL(url)) == null || !url.startsWith("/")) {
            throw new IllegalArgumentException("Invalid view ID: " + url);
        }
        if (context != null && !context.startsWith("/")) {
            throw new IllegalArgumentException("Invalid context path: " + context);
        }
        this.getChildren().clear();
        this.setSubviewId(url);
        this.setContext(context);
        this.setNewView(true);
    }

    public void reload() {
        this.setNewView(true);
    }

    public void unload() {
        UIComponent fallback;
        this.url = "";
        if (this.getSubviewId() != null) {
            this.getChildren().clear();
        }
        if ((fallback = (UIComponent)this.getFacets().get("fallback")) != null) {
            this.getChildren().addAll(fallback.getChildren());
            this.getFacets().remove("fallback");
        }
        this.setSubviewId(null);
        this.setNewView(true);
    }

    public abstract void setFrame(Boolean var1);

    public Boolean getFrame() {
        if (this.frame != null) {
            return this.frame;
        }
        ValueExpression ve = this.getValueExpression("frame");
        if (ve != null) {
            return (Boolean)ve.getValue(this.getFacesContext().getELContext());
        }
        return false;
    }

    public Object saveState(FacesContext context) {
        return new Object[]{super.saveState(context), this.subviewId};
    }

    public void restoreState(FacesContext context, Object state) {
        Object[] values = (Object[])state;
        super.restoreState(context, values[0]);
        this.subviewId = (String)values[1];
        this.viewRestored = true;
    }

    private String fixURL(String url) {
        String fixedURL = url;
        if (this.getFrame().booleanValue()) {
            fixedURL = FacesUtils.fixURL((String)url);
        } else {
            int paramPos;
            if (null != url && !url.startsWith("/")) {
                String viewId = this.getFacesContext().getViewRoot().getViewId();
                fixedURL = viewId.substring(0, viewId.lastIndexOf(47) + 1) + url;
            }
            if (null != fixedURL && (paramPos = fixedURL.indexOf(63)) > 0) {
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine("The request parameter [" + this.subviewId.substring(paramPos) + "] will be ignored in building subview.");
                }
                fixedURL = fixedURL.substring(0, paramPos);
            }
        }
        return fixedURL;
    }
}

