/*
 * Decompiled with CFR 0.152.
 */
package org.operamasks.faces.component.grid;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Formatter;
import java.util.List;
import javax.el.ELContext;
import javax.el.ValueExpression;
import javax.faces.context.FacesContext;
import javax.faces.convert.Converter;
import org.operamasks.faces.component.Align;
import org.operamasks.faces.component.grid.CellEditor;
import org.operamasks.faces.component.widget.ExtConfig;
import org.operamasks.faces.render.resource.Aliases;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GridColumn
implements Serializable {
    private static final long serialVersionUID = 4532196270979292701L;
    public static final String CHECK_COLUMN_TYPE = "check";
    public static final String PASSWORD_COLUMN_TYPE = "password";
    private String id;
    private boolean enableSort;
    private boolean hidden;
    private boolean hidable = true;
    private Align align;
    private int width;
    private String converter;
    private transient Converter attachedConverter;
    private List<CellEditor> cellEditors = new ArrayList<CellEditor>();
    private String value;
    private List<String> clientFormatters;
    private boolean requireEscape;
    private boolean wrap;
    private boolean fixed;
    private String style;
    private String styleClass;
    private String type;
    private String editorSelector;
    private String cellEditorRenderer;
    private ValueExpression ve;
    private String summaryType;
    private String summaryRenderer;

    public String getSummaryType() {
        return this.summaryType;
    }

    public void setSummaryType(String summaryType) {
        this.summaryType = summaryType;
    }

    public String getSummaryRenderer() {
        return this.summaryRenderer;
    }

    public void setSummaryRenderer(String summaryRenderer) {
        this.summaryRenderer = summaryRenderer;
    }

    public GridColumn(String id) {
        this.id = id;
    }

    public String getId() {
        return this.id;
    }

    public boolean isEnableSort() {
        return this.enableSort;
    }

    public void setEnableSort(boolean enableSort) {
        this.enableSort = enableSort;
    }

    public boolean isRequireEscape() {
        return this.requireEscape;
    }

    public void setRequireEscape(boolean requireEscape) {
        this.requireEscape = requireEscape;
    }

    public Align getAlign() {
        return this.align;
    }

    public void setAlign(Align align) {
        this.align = align;
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public void setValue(String value) {
        this.value = value;
        this.ve = null;
    }

    public String getValue() {
        return this.value;
    }

    public Converter getAttachedConverter() {
        return this.attachedConverter;
    }

    public void setAttachedConverter(Converter attachedConverter) {
        this.attachedConverter = attachedConverter;
    }

    public ValueExpression getValueExpression() {
        if (this.ve == null && this.value != null) {
            FacesContext fctx = FacesContext.getCurrentInstance();
            ELContext elctx = fctx.getELContext();
            this.ve = fctx.getApplication().getExpressionFactory().createValueExpression(elctx, this.value, Object.class);
        }
        return this.ve;
    }

    public String toScript(String header) {
        Aliases alias = Aliases.getInstance();
        Aliases.ConfigBuilder c = alias.configBuilder("grid");
        StringBuffer buf = new StringBuffer();
        Formatter fmt = new Formatter(buf);
        buf.append(c.start()).append("{");
        fmt.format("%s:%s", c.prop("header"), header);
        fmt.format(",%s:'%s'", c.prop("dataIndex"), this.id);
        if (this.fixed) {
            fmt.format(",%s:true", c.prop("fixed"));
        }
        if (this.enableSort) {
            fmt.format(",%s:true", c.prop("sortable"));
        }
        if (this.align != null) {
            fmt.format(",%s:'%s'", c.prop("align"), this.align.toString());
        }
        if (this.width > 0) {
            fmt.format(",%s:%d", c.prop("width"), this.width);
        }
        if (this.hidden) {
            fmt.format(",%s:%b", c.prop("hidden"), this.hidden);
        }
        fmt.format(",%s:%b", c.prop("hideable"), this.hidable);
        if (this.editorSelector != null && this.editorSelector.length() > 0) {
            fmt.format(",%s:%s", c.prop("editorSelector"), this.editorSelector);
        }
        if (this.wrap) {
            fmt.format(",%s:%b", c.prop("wrap"), this.wrap);
        }
        if (this.cellEditors.size() > 0) {
            CellEditor firstEditor = this.cellEditors.get(0);
            StringBuilder cellBuf = new StringBuilder();
            try {
                if (firstEditor != null) {
                    ExtConfig config = firstEditor.getExtraConfig();
                    if (config != null) {
                        String renderer = config.get("renderer", "");
                        if (renderer != null && renderer.length() > 0) {
                            this.cellEditorRenderer = renderer;
                        }
                        config.remove("renderer");
                        String extra = config.toScript(false);
                        if (extra.length() > 0) {
                            fmt.format(",%s", extra);
                        }
                    }
                    cellBuf.append("(");
                    int i = 1;
                    int n = this.cellEditors.size();
                    while (i < n) {
                        this.cellEditors.get(i).render(cellBuf);
                        cellBuf.append(",");
                        ++i;
                    }
                    firstEditor.render(cellBuf);
                    cellBuf.append(")");
                }
            }
            catch (IOException e) {
                cellBuf.setLength(0);
            }
            if (cellBuf.length() > 0) {
                fmt.format(",%s:%s", c.prop("editor"), cellBuf.toString());
            }
        }
        if (this.summaryType != null) {
            fmt.format(",%s:'%s'", c.prop("summaryType"), this.summaryType);
        }
        if (this.summaryRenderer != null) {
            fmt.format(",%s:%s", c.prop("summaryRenderer"), this.summaryRenderer);
        }
        if (this.type != null) {
            fmt.format(",%s:'%s'", c.prop("type"), this.type);
        }
        this.encodeClientFormaters(fmt, c);
        buf.append("}").append(c.end());
        return buf.toString();
    }

    private void encodeClientFormaters(Formatter fmt, Aliases.ConfigBuilder c) {
        String s;
        StringBuilder buf = new StringBuilder();
        Aliases alias = Aliases.getInstance((FacesContext)FacesContext.getCurrentInstance());
        boolean hasCellEditorRenderer = this.cellEditorRenderer != null && this.cellEditorRenderer.length() > 0;
        int count = this.isRequireEscape() ? 1 : 0;
        count += this.isWrap() ? 1 : 0;
        count += hasCellEditorRenderer ? 1 : 0;
        count += this.style != null || this.styleClass != null ? 1 : 0;
        if ((count += this.clientFormatters != null ? this.clientFormatters.size() : 0) > 1) {
            buf.append("function(v,m,r,row,col,s) {");
        }
        if (this.isRequireEscape()) {
            s = "OM.grid.escapeColumn";
            buf.append(count == 1 ? s : "v=" + s + "(v);");
        }
        if (this.isWrap()) {
            s = "OM.grid.wrap";
            buf.append(count == 1 ? s : "v=" + s + "(v);");
        }
        if (hasCellEditorRenderer) {
            buf.append(count == 1 ? this.cellEditorRenderer : "v=" + this.cellEditorRenderer + "(v);");
        }
        if (this.style != null || this.styleClass != null) {
            StringBuffer sb = new StringBuffer();
            if (this.style != null) {
                sb.append("m.attr = 'style=\"");
                sb.append(this.style);
                sb.append("\"';");
            }
            if (this.styleClass != null) {
                sb.append("m.css = '");
                sb.append(this.styleClass);
                sb.append("';");
            }
            if (count == 1) {
                buf.append(String.format("function(v,m){%sreturn v;}", sb.toString()));
            } else {
                buf.append(sb.toString());
            }
        }
        if (this.clientFormatters != null) {
            if (count > 1) {
                for (String formatter : this.clientFormatters) {
                    buf.append("v=").append(formatter).append("(v,m,r,row,col,s);");
                }
            } else {
                buf.append(this.clientFormatters.get(0));
            }
        }
        if (count > 1) {
            buf.append("return v;}");
        }
        if (CHECK_COLUMN_TYPE.equals(this.type)) {
            fmt.format(",%s:%s", c.prop("renderer"), "Ext.ux.plugins.CheckColumnRenderer");
        } else if (PASSWORD_COLUMN_TYPE.equals(this.type)) {
            fmt.format(",%s:%s", c.prop("renderer"), "Ext.ux.plugins.PasswordColumnRenderer");
        } else if (buf.length() > 0) {
            fmt.format(",%s:%s", c.prop("renderer"), buf.toString());
        }
    }

    public String getConverter() {
        return this.converter;
    }

    public void setConverter(String converter) {
        this.converter = converter;
    }

    public List<CellEditor> getCellEditors() {
        return this.cellEditors;
    }

    @Deprecated
    public CellEditor getCellEditor() {
        if (this.cellEditors.size() > 0) {
            return this.cellEditors.get(0);
        }
        return null;
    }

    public void addCellEditor(CellEditor cellEditor) {
        if (cellEditor != null && !this.cellEditors.contains(cellEditor)) {
            this.cellEditors.add(cellEditor);
        }
    }

    @Deprecated
    public void setCellEditor(CellEditor cellEditor) {
        this.addCellEditor(cellEditor);
    }

    public boolean isHidden() {
        return this.hidden;
    }

    public void setHidden(boolean hidden) {
        this.hidden = hidden;
    }

    public boolean isHidable() {
        return this.hidable;
    }

    public void setHidable(boolean hidable) {
        this.hidable = hidable;
    }

    public void setClientFormatter(String ... clientFormatter) {
        this.clientFormatters = new ArrayList<String>((Collection)Arrays.asList(clientFormatter));
    }

    public void addClientFormatter(String ... clientFormatters) {
        if (this.clientFormatters == null) {
            this.clientFormatters = new ArrayList<String>();
        }
        this.clientFormatters.addAll((Collection<String>)Arrays.asList(clientFormatters));
    }

    public void clearClientFormatter() {
        this.clientFormatters.clear();
    }

    public List<String> getClientFormatters() {
        return this.clientFormatters;
    }

    @Deprecated
    public String getClientFormatter() {
        if (this.clientFormatters != null && this.clientFormatters.size() > 0) {
            return this.clientFormatters.get(0);
        }
        return null;
    }

    public GridColumn enableSort(boolean enableSort) {
        this.setEnableSort(enableSort);
        return this;
    }

    public GridColumn align(Align align) {
        this.setAlign(align);
        return this;
    }

    public GridColumn width(int width) {
        this.setWidth(width);
        return this;
    }

    public GridColumn value(String value) {
        this.setValue(value);
        return this;
    }

    public GridColumn converter(String converter) {
        this.setConverter(converter);
        return this;
    }

    public GridColumn cellEditor(CellEditor cellEditor) {
        this.addCellEditor(cellEditor);
        return this;
    }

    public GridColumn hidden(boolean hidden) {
        this.setHidden(hidden);
        return this;
    }

    public GridColumn hidable(boolean hidable) {
        this.setHidable(hidable);
        return this;
    }

    public GridColumn clientFormatter(String ... clientFormatter) {
        this.setClientFormatter(clientFormatter);
        return this;
    }

    public GridColumn requireEscape(boolean requireEscape) {
        this.setRequireEscape(requireEscape);
        return this;
    }

    public boolean isFixed() {
        return this.fixed;
    }

    public void setFixed(boolean fixed) {
        this.fixed = fixed;
    }

    public String getStyle() {
        return this.style;
    }

    public void setStyle(String style) {
        this.style = style;
    }

    public String getStyleClass() {
        return this.styleClass;
    }

    public void setStyleClass(String styleClass) {
        this.styleClass = styleClass;
    }

    public String getEditorSelector() {
        return this.editorSelector;
    }

    public void setEditorSelector(String editorSelector) {
        this.editorSelector = editorSelector;
    }

    public boolean isWrap() {
        return this.wrap;
    }

    public void setWrap(boolean wrap) {
        this.wrap = wrap;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }
}

