/*
 * Decompiled with CFR 0.152.
 */
package org.operamasks.faces.component.grid;

import java.io.Serializable;
import java.util.Formatter;
import org.operamasks.faces.component.Align;
import org.operamasks.faces.render.resource.Aliases;
import org.operamasks.faces.util.HtmlEncoder;

public class GridHeaderCell
implements Serializable {
    private String label;
    private int rowspan = 1;
    private int colspan = 1;
    private Align align;
    private boolean requireEscape = true;

    public GridHeaderCell() {
    }

    public GridHeaderCell(String label) {
        this.label = label;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public int getRowspan() {
        return this.rowspan;
    }

    public void setRowspan(int rowspan) {
        this.rowspan = rowspan > 0 ? rowspan : 1;
    }

    public int getColspan() {
        return this.colspan;
    }

    public void setColspan(int colspan) {
        this.colspan = colspan > 0 ? colspan : 1;
    }

    public Align getAlign() {
        return this.align;
    }

    public void setAlign(Align align) {
        this.align = align;
    }

    public boolean isRequireEscape() {
        return this.requireEscape;
    }

    public void setRequireEscape(boolean requireEscape) {
        this.requireEscape = requireEscape;
    }

    public GridHeaderCell label(String label) {
        this.setLabel(label);
        return this;
    }

    public GridHeaderCell rowspan(int rowspan) {
        this.setRowspan(rowspan);
        return this;
    }

    public GridHeaderCell colspan(int colspan) {
        this.setColspan(colspan);
        return this;
    }

    public GridHeaderCell align(Align align) {
        this.setAlign(align);
        return this;
    }

    public GridHeaderCell requireEscape(Boolean requireEscape) {
        this.setRequireEscape(requireEscape);
        return this;
    }

    public String toScript() {
        Aliases alias = Aliases.getInstance();
        Aliases.ConfigBuilder c = alias.configBuilder("grid");
        StringBuffer buf = new StringBuffer();
        Formatter fmt = new Formatter(buf);
        buf.append(c.start()).append("{");
        fmt.format("%s:'%s'", c.prop("header"), this.label == null ? "" : (this.requireEscape ? HtmlEncoder.encode((String)this.label) : this.label));
        if (this.align != null) {
            fmt.format(",%s:'%s'", c.prop("align"), this.align.toString());
        }
        if (this.rowspan > 0) {
            fmt.format(",%s:%d", c.prop("rowspan"), this.rowspan);
        }
        if (this.colspan > 1) {
            fmt.format(",%s:%d", c.prop("colspan"), this.colspan);
        }
        buf.append("}").append(c.end());
        return buf.toString();
    }
}

