/*
 * Decompiled with CFR 0.152.
 */
package org.operamasks.faces.component.grid;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import org.operamasks.faces.component.grid.GridHeader;
import org.operamasks.faces.component.grid.GridHeaderCell;

public class GridHeaderModel
implements Serializable {
    private ArrayList<GridHeader> headers = new ArrayList();

    public GridHeader[] getHeaders() {
        return this.headers.toArray(new GridHeader[this.headers.size()]);
    }

    public GridHeader getHeader(int headerIndex) {
        return this.headers.get(headerIndex);
    }

    public int getHeadersCount() {
        return this.headers.size();
    }

    public void addHeader(GridHeader header) {
        this.headers.add(header);
        this.headers.trimToSize();
    }

    public GridHeaderModel headers(GridHeader ... headers) {
        this.headers.addAll(Arrays.asList(headers));
        this.headers.trimToSize();
        return this;
    }

    public void addHeader(int headerIndex, GridHeader header) {
        this.headers.add(headerIndex, header);
        this.headers.trimToSize();
    }

    public GridHeader removeHeader(int headerIndex) {
        GridHeader header = this.getHeader(headerIndex);
        this.headers.remove(header);
        return header;
    }

    public GridHeader removeHeader(GridHeader header) {
        return this.headers.remove(header) ? header : null;
    }

    public int getColumnCount() {
        if (this.headers == null || this.headers.size() == 0) {
            return 0;
        }
        int colsCount = 0;
        for (GridHeaderCell cell : this.headers.get(0).getCells()) {
            colsCount += cell.getColspan();
        }
        return colsCount;
    }

    public int getColumnCount(int row) {
        if (row < 0) {
            throw new IndexOutOfBoundsException("Index : " + row);
        }
        if (this.headers == null || this.headers.size() == 0) {
            return 0;
        }
        if (row >= this.headers.size()) {
            throw new IndexOutOfBoundsException("Index : " + row + " out of " + this.headers.size());
        }
        int colsCount = 0;
        for (int r = 0; r <= row; ++r) {
            for (GridHeaderCell cell : this.headers.get(r).getCells()) {
                if (r + cell.getRowspan() <= row) continue;
                ++colsCount;
            }
        }
        return colsCount;
    }

    public void reset() {
        this.headers.clear();
    }
}

