/*
 * Decompiled with CFR 0.152.
 */
package org.operamasks.faces.component.tree.base;

import java.util.ArrayList;
import java.util.List;
import javax.el.ELException;
import javax.el.ValueExpression;
import javax.faces.FacesException;
import javax.faces.component.UIComponent;
import javax.faces.component.UIComponentBase;
import javax.faces.context.FacesContext;
import org.operamasks.faces.component.tree.base.TreeDataProvider;
import org.operamasks.faces.component.tree.impl.UITree;
import org.operamasks.faces.component.tree.impl.UITreeNode;
import org.operamasks.faces.render.widget.helper.TreeRenderHelper;
import org.operamasks.faces.tools.annotation.ExtConfigOption;
import org.operamasks.faces.tools.annotation.Operation;
import org.operamasks.faces.util.DeepCloneable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class UITreeNodeBase
extends UIComponentBase
implements DeepCloneable {
    @ExtConfigOption
    protected String text;
    @ExtConfigOption
    protected String icon;
    @ExtConfigOption
    protected String id;
    @ExtConfigOption
    protected Boolean checked;
    @ExtConfigOption
    protected Boolean disabled;
    @ExtConfigOption
    protected Boolean expanded;
    @ExtConfigOption
    protected String href;
    @ExtConfigOption
    protected String hrefTarget;
    @ExtConfigOption
    protected Boolean leaf;
    @ExtConfigOption
    protected String qtip;
    @ExtConfigOption
    protected Boolean singleClickExpand;
    @ExtConfigOption
    protected String cls;
    @ExtConfigOption
    protected String iconCls;
    protected Boolean cascade;
    protected Object userData;
    private boolean updateAble;

    public boolean getUpdateAble() {
        return this.updateAble;
    }

    public void setUpdateAble(boolean updateAble) {
        this.updateAble = updateAble;
    }

    @Operation
    public void reloadChildren() {
    }

    public void reload() {
        TreeDataProvider dataProvider = this.getTree().getValue();
        if (dataProvider != null) {
            Object userData = this.userData;
            this.setText(dataProvider.getText(userData));
            this.setIcon(dataProvider.getIcon(userData));
            this.setChecked(dataProvider.isChecked(userData));
        }
    }

    @Operation
    public void remove() {
    }

    @Operation
    public void add(UITreeNode node) {
        this.addWithoutScript(node);
    }

    public void addWithoutScript(UITreeNode node) {
        if (node.getId() == null) {
            node.setId(TreeRenderHelper.createUniqueTreeNodeId(this.getTree()));
        }
        this.getChildren().add(node);
    }

    public UITree getTree() {
        for (UIComponent parent = this.getParent(); parent != null; parent = parent.getParent()) {
            if (!(parent instanceof UITree)) continue;
            return (UITree)parent;
        }
        return null;
    }

    @Operation
    public void setChecked(Boolean checked) {
        this.setCheckedWithoutScript(checked);
    }

    public void setCheckedWithoutScript(Boolean checked) {
        this.checked = checked;
    }

    public Boolean getChecked() {
        if (this.checked != null) {
            return this.checked;
        }
        ValueExpression ve = this.getValueExpression("checked");
        if (ve != null) {
            try {
                return (Boolean)ve.getValue(this.getFacesContext().getELContext());
            }
            catch (ELException e) {
                throw new FacesException((Throwable)e);
            }
        }
        return null;
    }

    @Operation
    public void setIcon(String icon) {
        this.icon = icon;
    }

    public String getIcon() {
        if (this.icon != null) {
            return this.icon;
        }
        ValueExpression ve = this.getValueExpression("icon");
        if (ve != null) {
            try {
                return (String)ve.getValue(this.getFacesContext().getELContext());
            }
            catch (ELException e) {
                throw new FacesException((Throwable)e);
            }
        }
        return null;
    }

    @Operation
    public void setText(String value) {
        this.text = value;
    }

    public String getText() {
        if (this.text != null) {
            return this.text;
        }
        ValueExpression ve = this.getValueExpression("text");
        if (ve != null) {
            try {
                return (String)ve.getValue(this.getFacesContext().getELContext());
            }
            catch (ELException e) {
                throw new FacesException((Throwable)e);
            }
        }
        return null;
    }

    public boolean isRoot() {
        return this.getParent() instanceof UITree;
    }

    public boolean isPartlyChecked() {
        if (Boolean.TRUE.equals(((UITreeNode)this).getLeaf()) || !Boolean.TRUE.equals(((UITreeNode)this).getCascade()) || ((UITreeNode)this).getChecked() == null) {
            return false;
        }
        List kids = this.getChildren();
        int checkedChildCount = 0;
        int checkableChildCount = 0;
        for (UIComponent kid : kids) {
            UITreeNode tn = (UITreeNode)kid;
            if (tn.isPartlyChecked()) {
                return true;
            }
            if (tn.getChecked() != null) {
                ++checkableChildCount;
            }
            if (!Boolean.TRUE.equals(tn.getChecked())) continue;
            ++checkedChildCount;
        }
        return checkedChildCount > 0 && checkedChildCount < checkableChildCount;
    }

    public List<UITreeNode> getPartlyCheckedChildren() {
        List kids = this.getChildren();
        ArrayList<UITreeNode> partlyCheckedNodes = new ArrayList<UITreeNode>();
        for (UIComponent kid : kids) {
            UITreeNode tn = (UITreeNode)kid;
            if (!tn.isPartlyChecked()) continue;
            partlyCheckedNodes.add(tn);
        }
        return partlyCheckedNodes;
    }

    public Object deepSaveState(FacesContext context) {
        return new Object[]{super.saveState(context), this.text, this.icon, this.id, this.checked, this.disabled, this.expanded, this.href, this.hrefTarget, this.leaf, this.qtip, this.singleClickExpand, this.cls, this.iconCls, this.cascade, this.userData, this.getUpdateAble()};
    }

    public void deepRestoreState(FacesContext context, Object state) {
        Object[] values = (Object[])state;
        super.restoreState(context, values[0]);
        this.text = (String)values[1];
        this.icon = (String)values[2];
        this.id = (String)values[3];
        this.checked = (Boolean)values[4];
        this.disabled = (Boolean)values[5];
        this.expanded = (Boolean)values[6];
        this.href = (String)values[7];
        this.hrefTarget = (String)values[8];
        this.leaf = (Boolean)values[9];
        this.qtip = (String)values[10];
        this.singleClickExpand = (Boolean)values[11];
        this.cls = (String)values[12];
        this.iconCls = (String)values[13];
        this.cascade = (Boolean)values[14];
        this.userData = values[15];
        this.setUpdateAble((Boolean)values[16]);
    }
}

