/*
 * Decompiled with CFR 0.152.
 */
package org.operamasks.faces.component.widget;

import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.el.ValueExpression;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import org.operamasks.faces.annotation.cache.AnnotationCache;
import org.operamasks.faces.annotation.cache.ClassMetaInfo;
import org.operamasks.faces.annotation.cache.MemberMetaInfo;
import org.operamasks.faces.render.resource.Aliases;
import org.operamasks.faces.tools.annotation.ExtConfigOption;
import org.operamasks.faces.util.HtmlEncoder;
import org.operamasks.util.BeanProperty;
import org.operamasks.util.BeanUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExtConfig
implements Serializable,
Cloneable {
    private static final long serialVersionUID = -1065034877736460926L;
    protected Map<String, Object> properties = new HashMap<String, Object>();
    protected Set<String> properties_isVar = new HashSet<String>();
    protected Map<String, PropertyModifier> propertyModifiers = new HashMap<String, PropertyModifier>();
    protected String initConfigText;

    public ExtConfig() {
    }

    public ExtConfig(UIComponent component) {
        this.populateConfig(component);
    }

    public void populateConfig(UIComponent component) {
        Class<?> compClass = component.getClass();
        AnnotationCache cache = AnnotationCache.getInstance();
        ClassMetaInfo clzmeta = cache.get(component.getClass());
        if (clzmeta == null) {
            cache.add(compClass);
            clzmeta = cache.get(component.getClass());
        }
        List fields = clzmeta.getFieldsInParent(ExtConfigOption.class);
        for (MemberMetaInfo field : fields) {
            ExtConfigOption meta = (ExtConfigOption)field.getAnnotation(ExtConfigOption.class);
            if (meta == null) continue;
            try {
                BeanProperty prop = BeanUtils.getProperty(compClass, (String)((Field)field.getAnnotatedMember()).getName());
                Object value = prop.getReadMethod().invoke((Object)component, new Object[0]);
                String key = meta.value();
                if (key == null || key.length() == 0) {
                    key = prop.getName();
                }
                this.set(key, value);
            }
            catch (Throwable e) {}
        }
    }

    protected Object get(String name) {
        return this.get(name, null);
    }

    public <T> T get(String name, T def) {
        Object result = this.properties.get(name);
        if (result == null) {
            result = def;
        } else if (result instanceof ValueExpression) {
            result = ((ValueExpression)result).getValue(FacesContext.getCurrentInstance().getELContext());
        }
        return (T)result;
    }

    public void set(String name, Object value) {
        this.set(name, value, false);
    }

    public void set(String name, Object value, boolean isVar) {
        this.set(name, value, isVar, false);
    }

    public void set(String name, Object value, boolean isVar, boolean allowNullValue) {
        if (value == null && !allowNullValue) {
            this.properties.remove(name);
            this.properties_isVar.remove(name);
        } else {
            this.properties.put(name, value);
            if (isVar) {
                this.properties_isVar.add(name);
            } else {
                this.properties_isVar.remove(name);
            }
        }
    }

    public boolean isSet(String name) {
        return this.properties.containsKey(name);
    }

    public boolean isVar(String name) {
        return this.properties_isVar.contains(name);
    }

    public void remove(String name) {
        this.properties.remove(name);
        this.properties_isVar.remove(name);
    }

    public void reset() {
        this.properties.clear();
        this.properties_isVar.clear();
    }

    public void merge(ExtConfig other) {
        for (Map.Entry<String, Object> entry : other.properties.entrySet()) {
            String k = entry.getKey();
            Object v = entry.getValue();
            this.set(k, v, other.isVar(k));
        }
        this.initConfigText = other.initConfigText;
    }

    public String toScript() {
        return this.toScript(null, true);
    }

    public String toScript(Aliases.ConfigBuilder c) {
        return this.toScript(null, true, c);
    }

    public String toScript(boolean escape) {
        return this.toScript(null, escape);
    }

    public String toScript(String exclusion) {
        return this.toScript(exclusion, true);
    }

    public String toScript(String exclusion, boolean escape) {
        return this.toScript(exclusion, escape, null);
    }

    public String toScript(String exclusion, boolean escape, Aliases.ConfigBuilder c) {
        String[] excludes = null;
        if (exclusion != null) {
            excludes = exclusion.split(",");
        }
        StringBuilder buf = new StringBuilder();
        block0: for (String name : this.properties.keySet()) {
            PropertyModifier modifier;
            Object value;
            if (excludes != null) {
                for (int j = 0; j < excludes.length; ++j) {
                    if (name.equals(excludes[j])) continue block0;
                }
            }
            if ((value = this.properties.get(name)) != null && value instanceof ValueExpression) {
                value = ((ValueExpression)value).getValue(FacesContext.getCurrentInstance().getELContext());
            }
            if ((modifier = this.propertyModifiers.get(name)) != null) {
                value = modifier.modifyValue(value);
            }
            if (value == null) continue;
            if (buf.length() > 0) {
                buf.append(",");
            }
            String actualName = this.getReplacedName(name);
            if (c != null) {
                actualName = c.prop(actualName);
            }
            buf.append(actualName).append(":");
            if (value instanceof String) {
                this.scriptOnStr(buf, name, (String)value, escape);
                continue;
            }
            buf.append(value);
        }
        if (this.initConfigText != null && this.initConfigText.trim().length() > 0) {
            if (buf.length() > 0) {
                buf.append(",");
            }
            buf.append(this.initConfigText);
        }
        return buf.toString();
    }

    protected String getReplacedName(String name) {
        return name;
    }

    protected void scriptOnStr(StringBuilder buf, String propName, String propValue) {
        this.scriptOnStr(buf, propName, propValue, true);
    }

    protected void scriptOnStr(StringBuilder buf, String propName, String propValue, boolean escape) {
        if (!this.properties_isVar.contains(propName) && escape) {
            buf.append(HtmlEncoder.enquote((String)propValue, (Character)Character.valueOf('\"')));
        } else {
            buf.append(propValue);
        }
    }

    public ExtConfig clone() {
        try {
            ExtConfig ec = (ExtConfig)super.clone();
            ec.properties = new HashMap<String, Object>();
            ec.properties.putAll(this.properties);
            ec.properties_isVar.addAll(this.properties_isVar);
            ec.initConfigText = this.initConfigText;
            return ec;
        }
        catch (CloneNotSupportedException ex) {
            throw new InternalError();
        }
    }

    public void setInitConfigText(String configText) {
        this.initConfigText = configText;
    }

    public void addPropertyModifiers(String propertyName, PropertyModifier modifier) {
        this.propertyModifiers.put(propertyName, modifier);
    }

    public static interface PropertyModifier {
        public Object modifyValue(Object var1);
    }
}

