/*
 * Decompiled with CFR 0.152.
 */
package org.operamasks.faces.component.widget.fileupload;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.faces.context.FacesContext;
import org.operamasks.faces.component.widget.UIFileUpload;
import org.operamasks.faces.component.widget.fileupload.UploadingStatus;
import org.operamasks.faces.component.widget.fileupload.UploadingStatusImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class UploadingMediator {
    private static final String FILE_UPLOAD_KEY_PREFIX = "org.operamasks.faces.FileUpload.";
    private static final String FILE_UPLOAD_CONTENT_SUFFIX = "_fileUploadSuffix";
    private static volatile UploadingMediator instance;
    private Lock progressorLock = new ReentrantLock();
    private static final String FILEUPLOADER_IDENTIFIER_KEY = "_request_identifier";

    private UploadingMediator() {
    }

    public static UploadingMediator getInstance() {
        if (instance == null) {
            instance = new UploadingMediator();
        }
        return instance;
    }

    public String getUploadingSerialNumber(FacesContext context) {
        return (String)this.getFromSession(context, this.getUploadingSerialNumberKey(context));
    }

    private String getUploadingSerialNumberKey(FacesContext context) {
        return "org.operamasks.faces.FileUpload..uploadingSerialNumber";
    }

    public boolean canStartUploading(FacesContext context) {
        return !this.isUploading(context);
    }

    public Object getFromSession(FacesContext context, String key) {
        return context.getExternalContext().getSessionMap().get(key);
    }

    private String getUploadingKey() {
        return "org.operamasks.faces.FileUpload.uploading";
    }

    public synchronized void startUploading(FacesContext context) {
        String uploadingSerialNumber = Long.toString(System.currentTimeMillis());
        this.putIntoSession(context, this.getUploadingSerialNumberKey(context), uploadingSerialNumber);
        this.putIntoSession(context, this.getUploadingKey(), "true");
        this.removeFromSession(context, this.getContentLengthKey());
        this.removeFromSession(context, this.getBytesReadKey());
        this.removeFromSession(context, this.getUploadingErrorKey());
        this.putProgressMark(context, true);
    }

    private String getProgressorMarkKey(boolean isStart) {
        if (isStart) {
            return "org.operamasks.faces.FileUpload.progressor_start";
        }
        return "org.operamasks.faces.FileUpload.progressor_end";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long getProgressorMark(FacesContext context, boolean isStart) {
        this.progressorLock.lock();
        try {
            Long l = (Long)this.getFromSession(context, this.getProgressorMarkKey(isStart));
            return l;
        }
        finally {
            this.progressorLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putProgressMark(FacesContext context, boolean isStart) {
        this.progressorLock.lock();
        try {
            Long value = null;
            String identifier = (String)context.getExternalContext().getRequestParameterMap().get(FILEUPLOADER_IDENTIFIER_KEY);
            if (identifier == null) {
                throw new IllegalStateException("Request identifier of fileuploader is not found.");
            }
            value = Long.valueOf(identifier);
            this.putIntoSession(context, this.getProgressorMarkKey(isStart), value);
        }
        finally {
            this.progressorLock.unlock();
        }
    }

    private void putIntoSession(FacesContext context, String key, Object value) {
        context.getExternalContext().getSessionMap().put(key, value);
    }

    public synchronized void cleanUploadingKey(FacesContext context) {
        this.removeFromSession(context, this.getUploadingSerialNumberKey(context));
        this.removeFromSession(context, this.getUploadingKey());
    }

    public synchronized void stopUploading(FacesContext context) {
        this.cleanUploadingKey(context);
        this.putProgressMark(context, false);
    }

    private Object removeFromSession(FacesContext context, String key) {
        return context.getExternalContext().getSessionMap().remove(key);
    }

    public void setContentLength(FacesContext context, long contentLength) {
        this.putIntoSession(context, this.getContentLengthKey(), contentLength);
    }

    private String getContentLengthKey() {
        return "org.operamasks.faces.FileUpload.contentLength";
    }

    public Long getContentLength(FacesContext context) {
        Long length = (Long)this.getFromSession(context, this.getContentLengthKey());
        if (length == null) {
            return 0L;
        }
        return length;
    }

    public void setBytesRead(FacesContext context, long bytesRead) {
        this.putIntoSession(context, this.getBytesReadKey(), bytesRead);
    }

    private String getBytesReadKey() {
        return "org.operamasks.faces.FileUpload.bytesRead";
    }

    public Long getBytesRead(FacesContext context) {
        Long length = (Long)this.getFromSession(context, this.getBytesReadKey());
        if (length == null) {
            return 0L;
        }
        return length;
    }

    private void setCurrentIndex(FacesContext context, int currentIndex) {
        this.putIntoSession(context, this.getCurrentIndexKey(), currentIndex);
    }

    public Long getCurrentIndex(FacesContext context) {
        Long length = (Long)this.getFromSession(context, this.getCurrentIndexKey());
        return length;
    }

    public void updateProgress(FacesContext context, long bytesRead, long contentLength, int currentIndex) {
        this.setBytesRead(context, bytesRead);
        this.setContentLength(context, contentLength);
        this.setCurrentIndex(context, currentIndex);
    }

    private String getCurrentIndexKey() {
        return "org.operamasks.faces.FileUpload.currentIndex";
    }

    public boolean isUploading(FacesContext context) {
        return this.getFromSession(context, this.getUploadingKey()) != null;
    }

    public boolean hasContextLengthSet(FacesContext context) {
        return this.getContentLength(context) != null;
    }

    public boolean needRefreshContentLength(FacesContext context, UIFileUpload fileUpload) {
        if (!this.isUploading(context)) {
            return false;
        }
        return fileUpload.getUploadingStatus() == null || !this.getUploadingSerialNumber(context).equals(fileUpload.getUploadingSerialNumber());
    }

    public void stopUploading(FacesContext context, Exception error) {
        context.getExternalContext().getSessionMap().put(this.getUploadingErrorKey(), error);
        this.stopUploading(context);
    }

    private String getUploadingErrorKey() {
        return "org.operamasks.faces.FileUpload.uploadingError";
    }

    public UploadingStatus getUploadingStatus(FacesContext context) {
        return UploadingStatusImpl.getInstance();
    }

    public Exception getError(FacesContext context) {
        return (Exception)this.getFromSession(context, this.getUploadingErrorKey());
    }

    public List<String> getFieldNames(FacesContext context) {
        List result = (List)context.getExternalContext().getRequestMap().get(this.getFieldNamesKey());
        return result;
    }

    private String getFieldNamesKey() {
        return "org.operamasks.faces.FileUpload.fieldNamesKey";
    }

    public void addFieldNames(FacesContext context, String fieldName) {
        ArrayList<String> fieldNamesList = (ArrayList<String>)context.getExternalContext().getRequestMap().get(this.getFieldNamesKey());
        if (fieldNamesList == null) {
            fieldNamesList = new ArrayList<String>();
        }
        fieldNamesList.add(fieldName);
        context.getExternalContext().getRequestMap().put(this.getFieldNamesKey(), fieldNamesList);
    }

    public String getUploadContentSuffix() {
        return FILE_UPLOAD_CONTENT_SUFFIX;
    }
}

