/*
 * Decompiled with CFR 0.152.
 */
package org.operamasks.faces.component.widget.invisible.base;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.faces.component.EditableValueHolder;
import javax.faces.component.UIComponent;
import javax.faces.component.UIData;
import javax.faces.context.FacesContext;
import javax.faces.event.FacesEvent;
import org.operamasks.faces.component.GenComponentUtils;
import org.operamasks.faces.render.ajax.AjaxResponseWriter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ForEachBase
extends UIData {
    public static final String COMPONENT_FAMILY = "org.operamasks.faces.widget.Invisible";
    protected String indexVar;
    protected Integer step;
    private Map<String, SavedState> saved = new HashMap<String, SavedState>();
    private boolean resetId;

    public String getFamily() {
        return COMPONENT_FAMILY;
    }

    public Map<String, SavedState> getSaved() {
        if (this.saved != null) {
            return this.saved;
        }
        Object exprValue = GenComponentUtils.getValueFromExpression((UIComponent)this, "saved");
        if (exprValue != null) {
            return (Map)exprValue;
        }
        return null;
    }

    public void setSaved(Map<String, SavedState> value) {
        this.saved = value;
    }

    public void queueEvent(FacesEvent event) {
        if (event == null) {
            throw new NullPointerException();
        }
        UIComponent parent = this.getParent();
        if (parent == null) {
            throw new IllegalStateException();
        }
        parent.queueEvent(event);
    }

    public void setRowIndex(int rowIndex) {
        super.setRowIndex(rowIndex);
        this.saveDescendantState();
        if (this.indexVar != null) {
            Map requestMap = this.getFacesContext().getExternalContext().getRequestMap();
            if (this.getDataModel().isRowAvailable()) {
                requestMap.put(this.indexVar, super.getRowIndex());
            } else {
                requestMap.remove(this.indexVar);
                super.setRowIndex(-1);
            }
        }
        this.restoreDescendantState();
    }

    private void saveDescendantState() {
        FacesContext context = this.getFacesContext();
        for (UIComponent kid : this.getChildren()) {
            this.saveDescendantState(kid, context);
        }
    }

    private void saveDescendantState(UIComponent component, FacesContext context) {
        if (component instanceof EditableValueHolder) {
            EditableValueHolder input = (EditableValueHolder)component;
            String clientId = component.getClientId(context);
            SavedState state = this.saved.get(clientId);
            if (state == null) {
                state = new SavedState();
                this.saved.put(clientId, state);
            }
            state.setValue(input.getLocalValue());
            state.setValid(input.isValid());
            state.setSubmittedValue(input.getSubmittedValue());
            state.setLocalValueSet(input.isLocalValueSet());
        }
        Iterator kids = component.getChildren().iterator();
        while (kids.hasNext()) {
            this.saveDescendantState((UIComponent)kids.next(), context);
        }
        Iterator facetNames = component.getFacets().keySet().iterator();
        while (facetNames.hasNext()) {
            UIComponent c = component.getFacet((String)facetNames.next());
            if (c == null) continue;
            this.saveDescendantState(c, context);
        }
    }

    public String getClientId(FacesContext context) {
        if (context == null) {
            throw new NullPointerException();
        }
        String baseClientId = super.getClientId(context);
        int rowIndex = super.getRowIndex();
        String ext = ":" + rowIndex;
        if (baseClientId.endsWith(ext)) {
            baseClientId = baseClientId.substring(0, baseClientId.length() - ext.length());
        }
        if (context.getResponseWriter() instanceof AjaxResponseWriter && this.getRows() != 0) {
            rowIndex %= this.getRows();
        }
        if (rowIndex >= 0) {
            return baseClientId + ':' + rowIndex;
        }
        return baseClientId;
    }

    private void restoreDescendantState() {
        FacesContext context = this.getFacesContext();
        for (UIComponent kid : this.getChildren()) {
            this.restoreDescendantState(kid, context);
        }
    }

    private void restoreDescendantState(UIComponent component, FacesContext context) {
        String id = component.getId();
        component.setId(id);
        if (component instanceof EditableValueHolder) {
            EditableValueHolder input = (EditableValueHolder)component;
            String clientId = component.getClientId(context);
            SavedState state = this.saved.get(clientId);
            if (state == null) {
                state = new SavedState();
            }
            input.setValue(state.getValue());
            input.setValid(state.isValid());
            input.setSubmittedValue(state.getSubmittedValue());
            input.setLocalValueSet(state.isLocalValueSet());
        }
        Iterator kids = component.getChildren().iterator();
        while (kids.hasNext()) {
            this.restoreDescendantState((UIComponent)kids.next(), context);
        }
        Iterator facetNames = component.getFacets().keySet().iterator();
        while (facetNames.hasNext()) {
            UIComponent c = component.getFacet((String)facetNames.next());
            if (c == null) continue;
            this.restoreDescendantState(c, context);
        }
    }

    public boolean isResetId() {
        return this.resetId;
    }

    public void setResetId(boolean resetId) {
        this.resetId = resetId;
    }

    public boolean getRendersChildren() {
        return true;
    }

    public Object saveState(FacesContext context) {
        return new Object[]{super.saveState(context), this.saved};
    }

    public void restoreState(FacesContext context, Object state) {
        Object[] values = (Object[])state;
        super.restoreState(context, values[0]);
        this.saved = (Map)values[1];
    }

    protected static class SavedState
    implements Serializable {
        private static final long serialVersionUID = 2920252657338389849L;
        private Object submittedValue;
        private boolean valid = true;
        private Object value;
        private boolean localValueSet;

        protected SavedState() {
        }

        Object getSubmittedValue() {
            return this.submittedValue;
        }

        void setSubmittedValue(Object submittedValue) {
            this.submittedValue = submittedValue;
        }

        boolean isValid() {
            return this.valid;
        }

        void setValid(boolean valid) {
            this.valid = valid;
        }

        Object getValue() {
            return this.value;
        }

        public void setValue(Object value) {
            this.value = value;
        }

        boolean isLocalValueSet() {
            return this.localValueSet;
        }

        public void setLocalValueSet(boolean localValueSet) {
            this.localValueSet = localValueSet;
        }

        public String toString() {
            return "submittedValue: " + this.submittedValue + " value: " + this.value + " localValueSet: " + this.localValueSet;
        }
    }
}

