/*
 * Decompiled with CFR 0.152.
 */
package org.operamasks.faces.component.widget.page;

import java.sql.ResultSet;
import java.util.Collections;
import java.util.List;
import javax.faces.model.ArrayDataModel;
import javax.faces.model.DataModel;
import javax.faces.model.DataModelEvent;
import javax.faces.model.DataModelListener;
import javax.faces.model.ListDataModel;
import javax.faces.model.ResultDataModel;
import javax.faces.model.ResultSetDataModel;
import javax.faces.model.ScalarDataModel;
import javax.servlet.jsp.jstl.sql.Result;
import org.operamasks.faces.component.widget.page.PagedDataProvider;

public class PagedDataModel
extends DataModel {
    private PagedDataProvider provider;
    private DataModel pagedModel;
    private int index;
    private int start = -1;
    private int limit = -1;
    private int rowCount = -1;
    private int[] currRange = new int[2];

    public PagedDataModel(PagedDataProvider provider) {
        this.setWrappedData(provider);
    }

    public int getRowCount() {
        return this.rowCount;
    }

    public Object getRowData() {
        if (this.provider == null) {
            return null;
        }
        if (!this.isRowAvailable()) {
            throw new IllegalArgumentException();
        }
        if (this.start == -1) {
            this.start = 0;
        }
        if (this.limit == -1) {
            this.limit = this.rowCount;
        }
        if (this.pagedModel == null) {
            this.createPagedDataModel(this.start, this.limit);
        }
        if (this.index < this.currRange[0] || this.index > this.currRange[1]) {
            this.start = this.index / this.limit * this.limit;
            this.createPagedDataModel(this.start, this.limit);
        }
        this.pagedModel.setRowIndex(this.index - this.start);
        if (this.pagedModel.isRowAvailable()) {
            return this.pagedModel.getRowData();
        }
        return null;
    }

    public int getRowIndex() {
        return this.index;
    }

    public Object getWrappedData() {
        return this.provider;
    }

    public boolean isRowAvailable() {
        return this.provider != null && this.index >= 0 && this.index < this.rowCount;
    }

    public void setRowIndex(int rowIndex) {
        if (rowIndex < -1) {
            throw new IllegalArgumentException();
        }
        int old = this.index;
        this.index = rowIndex;
        if (this.provider == null) {
            return;
        }
        DataModelListener[] listeners = this.getDataModelListeners();
        int n = listeners.length;
        if (old != this.index && n > 0) {
            Object rowData = null;
            if (this.isRowAvailable()) {
                rowData = this.getRowData();
            }
            DataModelEvent event = new DataModelEvent((DataModel)this, this.index, rowData);
            for (int i = 0; i < n; ++i) {
                if (null == listeners[i]) continue;
                listeners[i].rowSelected(event);
            }
        }
    }

    public void setWrappedData(Object data) {
        if (data == null) {
            this.setRowIndex(-1);
            throw new IllegalArgumentException("data must be an implemention of org.operamasks.faces.component.widget.page.PagedDataProvider");
        }
        this.provider = (PagedDataProvider)data;
        this.index = -1;
        this.rowCount = this.provider.getTotalCount();
    }

    private void createPagedDataModel(int start, int limit) {
        Object current = this.provider.getData(start, limit);
        this.pagedModel = current == null ? new ListDataModel(Collections.EMPTY_LIST) : (current instanceof DataModel ? (DataModel)current : (current instanceof List ? new ListDataModel((List)current) : (Object[].class.isAssignableFrom(current.getClass()) ? new ArrayDataModel((Object[])current) : (current instanceof ResultSet ? new ResultSetDataModel((ResultSet)current) : (current instanceof Result ? new ResultDataModel((Result)current) : new ScalarDataModel(current))))));
        this.currRange[0] = start;
        this.currRange[1] = start + limit - 1;
    }

    public int getStart() {
        return this.start;
    }

    public void setStart(int start) {
        this.start = start;
    }

    public int getLimit() {
        return this.limit;
    }

    public void setLimit(int limit) {
        this.limit = limit;
    }
}

