/*
 * Decompiled with CFR 0.152.
 */
package org.operamasks.faces.extra.messagebox;

import java.util.HashMap;
import java.util.Map;
import javax.faces.component.html.HtmlPanelGrid;
import javax.faces.context.FacesContext;
import org.operamasks.faces.annotation.Accessible;
import org.operamasks.faces.annotation.LocalString;
import org.operamasks.faces.annotation.ManagedBean;
import org.operamasks.faces.annotation.ManagedBeanScope;
import org.operamasks.faces.annotation.ManagedProperty;
import org.operamasks.faces.component.action.Action;
import org.operamasks.faces.component.ajax.AjaxUpdater;
import org.operamasks.faces.component.layout.impl.UIWindow;
import org.operamasks.faces.component.widget.UIButton;
import org.operamasks.faces.extra.messagebox.Button;
import org.operamasks.faces.extra.messagebox.MessageBoxAction;
import org.operamasks.faces.extra.messagebox.MessageBoxType;
import org.operamasks.faces.render.resource.ResourceManager;

@ManagedBean(name="org.operamasks.faces.extra.messagebox.MessageBox", scope=ManagedBeanScope.SESSION)
public class MessageBox {
    public static final String ERROR = "messagebox/icon-error.gif";
    public static final String INFO = "messagebox/icon-info.gif";
    public static final String QUESTION = "messagebox/icon-question.gif";
    public static final String WARNING = "messagebox/icon-warning.gif";
    public static final String MESSAGE_BOX_EVENT = "message_box_event";
    @ManagedProperty
    private UIWindow messageBox;
    private Map<MessageBoxType, MessageBoxHandler> handlers = new HashMap<MessageBoxType, MessageBoxHandler>();
    @Accessible
    private HtmlPanelGrid buttonContainer;
    @Accessible
    private String text;
    @Accessible
    private String icon;
    @Accessible
    private String title;
    @LocalString
    private Map<String, String> resources;
    @Accessible
    private AjaxUpdater updater;
    @Accessible
    private boolean modal = true;

    public MessageBox() {
        this.registMessageBoxType();
    }

    public void showMessageBox(String id, String text) {
        this.showMessageBox(id, MessageBoxType.ALERT, "", text, INFO, true);
    }

    public void showMessageBox(String id, String title, String text) {
        this.showMessageBox(id, MessageBoxType.ALERT, title, text, INFO, true);
    }

    public void showMessageBox(String id, String title, String text, String icon) {
        this.showMessageBox(id, MessageBoxType.ALERT, title, text, icon, true);
    }

    public void showMessageBox(String id, MessageBoxType type, String title, String text) {
        this.showMessageBox(id, type, title, text, INFO, true);
    }

    public void showMessageBox(String id, MessageBoxType type, String title, String text, String icon) {
        this.showMessageBox(id, type, title, text, icon, true);
    }

    public void showMessageBox(String id, MessageBoxType type, String title, String text, String icon, boolean modal) {
        this.title = title;
        this.text = text;
        this.icon = icon;
        this.modal = modal;
        if (this.isKnownIcon(icon)) {
            FacesContext context = FacesContext.getCurrentInstance();
            ResourceManager rm = ResourceManager.getInstance((FacesContext)context);
            this.icon = rm.getResourceURL(icon);
            this.icon = this.icon.substring(1);
            this.icon = this.icon.substring(this.icon.indexOf(47));
        }
        MessageBoxHandler handler = this.handlers.get((Object)type);
        handler.showMessageBox(id, type);
    }

    private boolean isKnownIcon(String icon) {
        return ERROR.equals(icon) || INFO.equals(icon) || QUESTION.equals(icon) || WARNING.equals(icon);
    }

    private void registMessageBoxType() {
        this.handlers.put(MessageBoxType.YESNO, new YesNoMessageBox());
        this.handlers.put(MessageBoxType.OKCANCEL, new OkCancelMessageBox());
        this.handlers.put(MessageBoxType.YESNOCANCEL, new YesNoCancelMessageBox());
    }

    class YesNoCancelMessageBox
    extends MessageBoxHandler {
        YesNoCancelMessageBox() {
        }

        void createMessageBox(String id) {
            UIButton yesButton = new UIButton();
            MessageBoxAction yesAction = new MessageBoxAction(Button.YES);
            yesAction.setMessageBoxId(id);
            yesAction.setAttribute("value", MessageBox.this.resources.get("yes.label"));
            yesButton.setActionBinding((Action)yesAction);
            UIButton noButton = new UIButton();
            MessageBoxAction noAction = new MessageBoxAction(Button.NO);
            noAction.setMessageBoxId(id);
            noAction.setAttribute("value", MessageBox.this.resources.get("no.label"));
            noButton.setActionBinding((Action)noAction);
            UIButton cancelButton = new UIButton();
            MessageBoxAction cancelAction = new MessageBoxAction(Button.CANCEL);
            cancelAction.setMessageBoxId(id);
            cancelAction.setAttribute("value", MessageBox.this.resources.get("cancel.label"));
            cancelButton.setActionBinding((Action)cancelAction);
            MessageBox.this.buttonContainer.getChildren().clear();
            MessageBox.this.buttonContainer.getChildren().add(yesButton);
            MessageBox.this.buttonContainer.getChildren().add(noButton);
            MessageBox.this.buttonContainer.getChildren().add(cancelButton);
        }
    }

    class OkCancelMessageBox
    extends MessageBoxHandler {
        OkCancelMessageBox() {
        }

        void createMessageBox(String id) {
            UIButton okButton = new UIButton();
            MessageBoxAction okAction = new MessageBoxAction(Button.OK);
            okAction.setMessageBoxId(id);
            okAction.setAttribute("value", MessageBox.this.resources.get("ok.label"));
            okButton.setActionBinding((Action)okAction);
            UIButton cancelButton = new UIButton();
            MessageBoxAction cancelAction = new MessageBoxAction(Button.CANCEL);
            cancelAction.setMessageBoxId(id);
            cancelAction.setAttribute("value", MessageBox.this.resources.get("cancel.label"));
            cancelButton.setActionBinding((Action)cancelAction);
            MessageBox.this.buttonContainer.getChildren().clear();
            MessageBox.this.buttonContainer.getChildren().add(okButton);
            MessageBox.this.buttonContainer.getChildren().add(cancelButton);
        }
    }

    class YesNoMessageBox
    extends MessageBoxHandler {
        YesNoMessageBox() {
        }

        void createMessageBox(String id) {
            UIButton yesButton = new UIButton();
            MessageBoxAction yesAction = new MessageBoxAction(Button.YES);
            yesAction.setMessageBoxId(id);
            yesAction.setAttribute("value", MessageBox.this.resources.get("yes.label"));
            yesButton.setActionBinding((Action)yesAction);
            UIButton noButton = new UIButton();
            MessageBoxAction noAction = new MessageBoxAction(Button.NO);
            noAction.setMessageBoxId(id);
            noAction.setAttribute("value", MessageBox.this.resources.get("no.label"));
            noButton.setActionBinding((Action)noAction);
            MessageBox.this.buttonContainer.getChildren().clear();
            MessageBox.this.buttonContainer.getChildren().add(yesButton);
            MessageBox.this.buttonContainer.getChildren().add(noButton);
        }
    }

    abstract class MessageBoxHandler {
        MessageBoxHandler() {
        }

        void showMessageBox(String id, MessageBoxType type) {
            this.createMessageBox(id);
            MessageBox.this.messageBox.setTitle(MessageBox.this.title);
            MessageBox.this.messageBox.setModal(MessageBox.this.modal);
            MessageBox.this.updater.getChildren().clear();
            MessageBox.this.updater.getChildren().add(MessageBox.this.buttonContainer);
            MessageBox.this.updater.reload();
            MessageBox.this.messageBox.show();
        }

        abstract void createMessageBox(String var1);
    }
}

