/*
 * Decompiled with CFR 0.152.
 */
package org.operamasks.faces.extra.messagebox;

import javax.faces.component.UIComponent;
import javax.faces.event.AbortProcessingException;
import org.operamasks.faces.component.action.AbstractAction;
import org.operamasks.faces.component.action.ActionEvent;
import org.operamasks.faces.component.layout.impl.UIWindow;
import org.operamasks.faces.event.EventBroadcaster;
import org.operamasks.faces.extra.messagebox.Button;
import org.operamasks.faces.extra.messagebox.MessageBoxEvent;

public class MessageBoxAction
extends AbstractAction {
    private Button button;
    private String messageBoxId;

    public MessageBoxAction(Button button) {
        this.setAttribute("minWidth", 75);
        this.button = button;
    }

    protected UIWindow findTarget(UIComponent source) {
        UIComponent parent = source;
        while ((parent = parent.getParent()) != null) {
            if (!(parent instanceof UIWindow)) continue;
            return (UIWindow)parent;
        }
        return null;
    }

    public void processAction(ActionEvent event) throws AbortProcessingException {
        EventBroadcaster broadcaster = EventBroadcaster.getInstance();
        MessageBoxEvent mEvent = new MessageBoxEvent(this.findTarget((UIComponent)event.getSource()), this.button);
        mEvent.setMessageboxId(this.messageBoxId);
        broadcaster.broadcast((Object)this.button, "message_box_event", new Object[]{mEvent});
    }

    public String getMessageBoxId() {
        return this.messageBoxId;
    }

    public void setMessageBoxId(String messageBoxId) {
        this.messageBoxId = messageBoxId;
    }
}

