/*
 * Decompiled with CFR 0.152.
 */
package org.operamasks.faces.facelets.widget;

import com.sun.facelets.FaceletContext;
import com.sun.facelets.tag.jsf.ComponentConfig;
import java.io.IOException;
import javax.el.ELException;
import javax.faces.FacesException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import org.operamasks.faces.component.ajax.AjaxAction;
import org.operamasks.faces.component.grid.GridHeader;
import org.operamasks.faces.component.grid.GridHeaderModel;
import org.operamasks.faces.component.grid.UIOutputColumn;
import org.operamasks.faces.component.grid.impl.UIDataGrid;
import org.operamasks.faces.facelets.util.AttributeSettingHandler;

public class GridHandler
extends AttributeSettingHandler {
    public static final String DATAGRID_MARKER = "org.operamasks.aom.datagridMarker_";
    private String componentType;

    public GridHandler(ComponentConfig config) {
        super(config);
        this.componentType = config.getComponentType();
    }

    protected void applyNextHandler(FaceletContext ctx, UIComponent c) throws IOException, FacesException, ELException {
        UIDataGrid grid = (UIDataGrid)c;
        this.cleanGridHeaderCreatedByTag(grid);
        this.referenceToSession(ctx, grid);
        super.applyNextHandler(ctx, c);
        this.removeDuplicateUIOutputColumn(grid);
    }

    private void removeDuplicateUIOutputColumn(UIDataGrid grid) {
        int childCount = grid.getChildCount();
        Boolean flag = null;
        Boolean typefFlag = false;
        int i = 0;
        while (i < childCount - 1) {
            UIComponent child = (UIComponent)grid.getChildren().get(i);
            flag = null;
            typefFlag = false;
            if (child instanceof AjaxAction) {
                typefFlag = true;
                flag = true;
            } else if (child instanceof UIOutputColumn) {
                typefFlag = true;
                flag = false;
            }
            if (typefFlag.booleanValue()) {
                int j = i + 1;
                while (j < childCount) {
                    UIComponent prechild = (UIComponent)grid.getChildren().get(j);
                    if (prechild instanceof AjaxAction && flag != null && flag.booleanValue()) {
                        String preEvent = ((AjaxAction)prechild).getEvent();
                        if (((AjaxAction)child).getEvent().equals(preEvent)) {
                            System.out.println("log -- removeAction--event--" + preEvent);
                            grid.getChildren().remove(child);
                            --childCount;
                            --i;
                            break;
                        }
                    } else if (prechild instanceof UIOutputColumn && flag != null && !flag.booleanValue()) {
                        String preId = prechild.getId();
                        if (child.getId().equals(preId)) {
                            System.out.println("log -- removeColumn--id--" + preId);
                            grid.getChildren().remove(child);
                            --childCount;
                            --i;
                            break;
                        }
                    }
                    ++j;
                }
            }
            ++i;
        }
    }

    private void referenceToSession(FaceletContext ctx, UIDataGrid grid) {
        FacesContext facesContext = ctx.getFacesContext();
        facesContext.getExternalContext().getSessionMap().put(DATAGRID_MARKER + grid.getId(), grid);
    }

    private void cleanGridHeaderCreatedByTag(UIDataGrid grid) {
        GridHeaderModel headerModel = grid.getHeaderModel();
        if (headerModel != null) {
            GridHeader[] gridHeaderArray = headerModel.getHeaders();
            int n = gridHeaderArray.length;
            int n2 = 0;
            while (n2 < n) {
                GridHeader header = gridHeaderArray[n2];
                if (header.isCreateFromTag()) {
                    grid.getHeaderModel().removeHeader(header);
                }
                ++n2;
            }
        }
    }
}

