/*
 * Decompiled with CFR 0.152.
 */
package org.operamasks.faces.facelets.widget;

import com.sun.facelets.FaceletContext;
import com.sun.facelets.FaceletException;
import com.sun.facelets.tag.TagAttribute;
import com.sun.facelets.tag.TagConfig;
import com.sun.facelets.tag.TagHandler;
import java.io.IOException;
import javax.el.ELException;
import javax.faces.FacesException;
import javax.faces.application.Application;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import org.operamasks.faces.component.Align;
import org.operamasks.faces.component.grid.GridHeaderCell;
import org.operamasks.faces.component.grid.GridHeaderModel;
import org.operamasks.faces.component.grid.impl.UIDataGrid;
import org.operamasks.resources.Resources;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GridHeaderCellHandler
extends TagHandler {
    public GridHeaderCellHandler(TagConfig config) {
        super(config);
    }

    public void apply(FaceletContext ctx, UIComponent parent) throws IOException, FacesException, FaceletException, ELException {
        Boolean requireEscape;
        String align;
        Integer rowspan;
        while (parent != null && !(parent instanceof UIDataGrid)) {
            parent = parent.getParent();
        }
        if (parent == null) {
            throw new FacesException(Resources._T((String)"UI_MISSING_PARENT", (Object[])new Object[]{"GridHeaderCell", "UIDataGrid"}));
        }
        UIDataGrid grid = (UIDataGrid)parent;
        GridHeaderModel headerModel = grid.getHeaderModel();
        if (headerModel == null || headerModel.getHeadersCount() == 0) {
            throw new FacesException(Resources._T((String)"UI_MISSING_PARENT", (Object[])new Object[]{"GridHeaderCell", "GridHeader"}));
        }
        int lastAdded = headerModel.getHeadersCount() - 1;
        GridHeaderCell headerCell = new GridHeaderCell();
        FacesContext fctx = ctx.getFacesContext();
        Application app = fctx.getApplication();
        Integer colspan = this.getAttributeValue(ctx, "colspan", Integer.class);
        if (colspan != null) {
            headerCell.setColspan(colspan);
        }
        if ((rowspan = this.getAttributeValue(ctx, "rowspan", Integer.class)) != null) {
            headerCell.setRowspan(rowspan);
        }
        String label = this.getAttributeValue(ctx, "label", String.class);
        try {
            label = (String)app.evaluateExpressionGet(fctx, label, String.class);
        }
        catch (UnsupportedOperationException ex) {
            // empty catch block
        }
        if (label != null) {
            headerCell.setLabel(label);
        }
        if ((align = this.getAttributeValue(ctx, "align", String.class)) != null) {
            headerCell.setAlign(Align.valueOf(align.trim().toUpperCase()));
        }
        if ((requireEscape = this.getAttributeValue(ctx, "requireEscape", Boolean.class)) != null) {
            headerCell.setRequireEscape(requireEscape);
        }
        headerModel.getHeader(lastAdded).addCell(headerCell);
    }

    private <T> T getAttributeValue(FaceletContext ctx, String name, Class<T> type) {
        TagAttribute attr = this.getAttribute(name);
        if (attr == null) {
            return null;
        }
        return (T)attr.getValueExpression(ctx, type).getValue(ctx.getFacesContext().getELContext());
    }
}

